package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_USER_TOKEN *
 * @author genrator
 */
public class EbUserToken_mapper extends EbUserToken implements BaseMapper<EbUserToken> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbUserToken> ROW_MAPPER = new EbUserTokenRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String Uid = "uid";
    public static final String Token = "token";
    public static final String Type = "type";
    public static final String CreateTime = "create_time";
    public static final String ExpiresTime = "expires_time";
    public static final String LoginIp = "login_ip";
    public static final String IsDel = "is_del";

    /**
     * 默认构造函数
     */
    public EbUserToken_mapper(EbUserToken ebUserToken) {
        if (ebUserToken == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebUserToken.isset_id) {
            this.setId(ebUserToken.getId());
        }
        //普通属性
        if (ebUserToken.isset_uid) {
            this.setUid(ebUserToken.getUid());
        }
        if (ebUserToken.isset_token) {
            this.setToken(ebUserToken.getToken());
        }
        if (ebUserToken.isset_type) {
            this.setType(ebUserToken.getType());
        }
        if (ebUserToken.isset_createTime) {
            this.setCreateTime(ebUserToken.getCreateTime());
        }
        if (ebUserToken.isset_expiresTime) {
            this.setExpiresTime(ebUserToken.getExpiresTime());
        }
        if (ebUserToken.isset_loginIp) {
            this.setLoginIp(ebUserToken.getLoginIp());
        }
        if (ebUserToken.isset_isDel) {
            this.setIsDel(ebUserToken.getIsDel());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_user_token.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_user_token";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(Uid, this.getUid(), this.isset_uid);
        ib.set(Token, this.getToken(), this.isset_token);
        ib.set(Type, this.getType(), this.isset_type);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(ExpiresTime, this.getExpiresTime(), this.isset_expiresTime);
        ib.set(LoginIp, this.getLoginIp(), this.isset_loginIp);
        ib.set(IsDel, this.getIsDel(), this.isset_isDel);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(Token, this.getToken(), this.isset_token);
        ub.set(Type, this.getType(), this.isset_type);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(ExpiresTime, this.getExpiresTime(), this.isset_expiresTime);
        ub.set(LoginIp, this.getLoginIp(), this.isset_loginIp);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(Token, this.getToken(), this.isset_token);
        ub.set(Type, this.getType(), this.isset_type);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(ExpiresTime, this.getExpiresTime(), this.isset_expiresTime);
        ub.set(LoginIp, this.getLoginIp(), this.isset_loginIp);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Uid, this.getUid(), this.isset_uid);
        ub.set(Token, this.getToken(), this.isset_token);
        ub.set(Type, this.getType(), this.isset_type);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(ExpiresTime, this.getExpiresTime(), this.isset_expiresTime);
        ub.set(LoginIp, this.getLoginIp(), this.isset_loginIp);
        ub.set(IsDel, this.getIsDel(), this.isset_isDel);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, uid, token, type, create_time, expires_time, login_ip, is_del from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, uid, token, type, create_time, expires_time, login_ip, is_del from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbUserToken mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbUserToken toEbUserToken() {
        return super.$clone();
    }
}

/**
 * eb_user_token RowMapper
 *
 * @author genrator
 */
class EbUserTokenRowMapper implements RowMapper<EbUserToken> {

    @Override
    public EbUserToken mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbUserToken eb_user_token = new EbUserToken();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbUserToken_mapper.Id);
        if (columnIndex > 0) {
            eb_user_token.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbUserToken_mapper.Uid);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_token.setUid(null);
            } else {
                eb_user_token.setUid(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserToken_mapper.Token);
        if (columnIndex > 0) {
            eb_user_token.setToken(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserToken_mapper.Type);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_token.setType(null);
            } else {
                eb_user_token.setType(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserToken_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_token.setCreateTime(null);
            } else {
                eb_user_token.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserToken_mapper.ExpiresTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_token.setExpiresTime(null);
            } else {
                eb_user_token.setExpiresTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserToken_mapper.LoginIp);
        if (columnIndex > 0) {
            eb_user_token.setLoginIp(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbUserToken_mapper.IsDel);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_user_token.setIsDel(null);
            } else {
                eb_user_token.setIsDel(rs.getInt(columnIndex));
            }
        }
        return eb_user_token;
    }
}
