package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_WECHAT_CALLBACK *
 * @author genrator
 */
public class EbWechatCallback_mapper extends EbWechatCallback implements BaseMapper<EbWechatCallback> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbWechatCallback> ROW_MAPPER = new EbWechatCallbackRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String ToUserName = "to_user_name";
    public static final String FromUserName = "from_user_name";
    public static final String CreateTime = "create_time";
    public static final String MsgType = "msg_type";
    public static final String Event = "event";
    public static final String Content = "content";
    public static final String AddTime = "add_time";

    /**
     * 默认构造函数
     */
    public EbWechatCallback_mapper(EbWechatCallback ebWechatCallback) {
        if (ebWechatCallback == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebWechatCallback.isset_id) {
            this.setId(ebWechatCallback.getId());
        }
        //普通属性
        if (ebWechatCallback.isset_toUserName) {
            this.setToUserName(ebWechatCallback.getToUserName());
        }
        if (ebWechatCallback.isset_fromUserName) {
            this.setFromUserName(ebWechatCallback.getFromUserName());
        }
        if (ebWechatCallback.isset_createTime) {
            this.setCreateTime(ebWechatCallback.getCreateTime());
        }
        if (ebWechatCallback.isset_msgType) {
            this.setMsgType(ebWechatCallback.getMsgType());
        }
        if (ebWechatCallback.isset_event) {
            this.setEvent(ebWechatCallback.getEvent());
        }
        if (ebWechatCallback.isset_content) {
            this.setContent(ebWechatCallback.getContent());
        }
        if (ebWechatCallback.isset_addTime) {
            this.setAddTime(ebWechatCallback.getAddTime());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_wechat_callback.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_wechat_callback";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(ToUserName, this.getToUserName(), this.isset_toUserName);
        ib.set(FromUserName, this.getFromUserName(), this.isset_fromUserName);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(MsgType, this.getMsgType(), this.isset_msgType);
        ib.set(Event, this.getEvent(), this.isset_event);
        ib.set(Content, this.getContent(), this.isset_content);
        ib.set(AddTime, this.getAddTime(), this.isset_addTime);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(ToUserName, this.getToUserName(), this.isset_toUserName);
        ub.set(FromUserName, this.getFromUserName(), this.isset_fromUserName);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(MsgType, this.getMsgType(), this.isset_msgType);
        ub.set(Event, this.getEvent(), this.isset_event);
        ub.set(Content, this.getContent(), this.isset_content);
        ub.set(AddTime, this.getAddTime(), this.isset_addTime);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(ToUserName, this.getToUserName(), this.isset_toUserName);
        ub.set(FromUserName, this.getFromUserName(), this.isset_fromUserName);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(MsgType, this.getMsgType(), this.isset_msgType);
        ub.set(Event, this.getEvent(), this.isset_event);
        ub.set(Content, this.getContent(), this.isset_content);
        ub.set(AddTime, this.getAddTime(), this.isset_addTime);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(ToUserName, this.getToUserName(), this.isset_toUserName);
        ub.set(FromUserName, this.getFromUserName(), this.isset_fromUserName);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(MsgType, this.getMsgType(), this.isset_msgType);
        ub.set(Event, this.getEvent(), this.isset_event);
        ub.set(Content, this.getContent(), this.isset_content);
        ub.set(AddTime, this.getAddTime(), this.isset_addTime);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, to_user_name, from_user_name, create_time, msg_type, event, content, add_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, to_user_name, from_user_name, create_time, msg_type, event, content, add_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbWechatCallback mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbWechatCallback toEbWechatCallback() {
        return super.$clone();
    }
}

/**
 * eb_wechat_callback RowMapper
 *
 * @author genrator
 */
class EbWechatCallbackRowMapper implements RowMapper<EbWechatCallback> {

    @Override
    public EbWechatCallback mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbWechatCallback eb_wechat_callback = new EbWechatCallback();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbWechatCallback_mapper.Id);
        if (columnIndex > 0) {
            eb_wechat_callback.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbWechatCallback_mapper.ToUserName);
        if (columnIndex > 0) {
            eb_wechat_callback.setToUserName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatCallback_mapper.FromUserName);
        if (columnIndex > 0) {
            eb_wechat_callback.setFromUserName(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatCallback_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_wechat_callback.setCreateTime(null);
            } else {
                eb_wechat_callback.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatCallback_mapper.MsgType);
        if (columnIndex > 0) {
            eb_wechat_callback.setMsgType(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatCallback_mapper.Event);
        if (columnIndex > 0) {
            eb_wechat_callback.setEvent(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatCallback_mapper.Content);
        if (columnIndex > 0) {
            eb_wechat_callback.setContent(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatCallback_mapper.AddTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_wechat_callback.setAddTime(null);
            } else {
                eb_wechat_callback.setAddTime(rs.getLong(columnIndex));
            }
        }
        return eb_wechat_callback;
    }
}
