package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_WECHAT_EXCEPTIONS *
 * @author genrator
 */
public class EbWechatExceptions_mapper extends EbWechatExceptions implements BaseMapper<EbWechatExceptions> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbWechatExceptions> ROW_MAPPER = new EbWechatExceptionsRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String Errcode = "errcode";
    public static final String Errmsg = "errmsg";
    public static final String Data = "data";
    public static final String Remark = "remark";
    public static final String CreateTime = "create_time";
    public static final String UpdateTime = "update_time";

    /**
     * 默认构造函数
     */
    public EbWechatExceptions_mapper(EbWechatExceptions ebWechatExceptions) {
        if (ebWechatExceptions == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebWechatExceptions.isset_id) {
            this.setId(ebWechatExceptions.getId());
        }
        //普通属性
        if (ebWechatExceptions.isset_errcode) {
            this.setErrcode(ebWechatExceptions.getErrcode());
        }
        if (ebWechatExceptions.isset_errmsg) {
            this.setErrmsg(ebWechatExceptions.getErrmsg());
        }
        if (ebWechatExceptions.isset_data) {
            this.setData(ebWechatExceptions.getData());
        }
        if (ebWechatExceptions.isset_remark) {
            this.setRemark(ebWechatExceptions.getRemark());
        }
        if (ebWechatExceptions.isset_createTime) {
            this.setCreateTime(ebWechatExceptions.getCreateTime());
        }
        if (ebWechatExceptions.isset_updateTime) {
            this.setUpdateTime(ebWechatExceptions.getUpdateTime());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_wechat_exceptions.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_wechat_exceptions";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(Errcode, this.getErrcode(), this.isset_errcode);
        ib.set(Errmsg, this.getErrmsg(), this.isset_errmsg);
        ib.set(Data, this.getData(), this.isset_data);
        ib.set(Remark, this.getRemark(), this.isset_remark);
        ib.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ib.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Errcode, this.getErrcode(), this.isset_errcode);
        ub.set(Errmsg, this.getErrmsg(), this.isset_errmsg);
        ub.set(Data, this.getData(), this.isset_data);
        ub.set(Remark, this.getRemark(), this.isset_remark);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Errcode, this.getErrcode(), this.isset_errcode);
        ub.set(Errmsg, this.getErrmsg(), this.isset_errmsg);
        ub.set(Data, this.getData(), this.isset_data);
        ub.set(Remark, this.getRemark(), this.isset_remark);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(Errcode, this.getErrcode(), this.isset_errcode);
        ub.set(Errmsg, this.getErrmsg(), this.isset_errmsg);
        ub.set(Data, this.getData(), this.isset_data);
        ub.set(Remark, this.getRemark(), this.isset_remark);
        ub.set(CreateTime, this.getCreateTime(), this.isset_createTime);
        ub.set(UpdateTime, this.getUpdateTime(), this.isset_updateTime);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, errcode, errmsg, data, remark, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, errcode, errmsg, data, remark, create_time, update_time from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbWechatExceptions mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbWechatExceptions toEbWechatExceptions() {
        return super.$clone();
    }
}

/**
 * eb_wechat_exceptions RowMapper
 *
 * @author genrator
 */
class EbWechatExceptionsRowMapper implements RowMapper<EbWechatExceptions> {

    @Override
    public EbWechatExceptions mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbWechatExceptions eb_wechat_exceptions = new EbWechatExceptions();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbWechatExceptions_mapper.Id);
        if (columnIndex > 0) {
            eb_wechat_exceptions.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbWechatExceptions_mapper.Errcode);
        if (columnIndex > 0) {
            eb_wechat_exceptions.setErrcode(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatExceptions_mapper.Errmsg);
        if (columnIndex > 0) {
            eb_wechat_exceptions.setErrmsg(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatExceptions_mapper.Data);
        if (columnIndex > 0) {
            eb_wechat_exceptions.setData(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatExceptions_mapper.Remark);
        if (columnIndex > 0) {
            eb_wechat_exceptions.setRemark(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatExceptions_mapper.CreateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_wechat_exceptions.setCreateTime(null);
            } else {
                eb_wechat_exceptions.setCreateTime(rs.getLong(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatExceptions_mapper.UpdateTime);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_wechat_exceptions.setUpdateTime(null);
            } else {
                eb_wechat_exceptions.setUpdateTime(rs.getLong(columnIndex));
            }
        }
        return eb_wechat_exceptions;
    }
}
