package com.ishop.model.po;

import com.walker.jdbc.BaseMapper;
import com.walker.jdbc.ResultSetUtils;
import com.walker.jdbc.SqlAndParameters;
import com.walker.jdbc.sqlgen.DeleteBuilder;
import com.walker.jdbc.sqlgen.InsertBuilder;
import com.walker.jdbc.sqlgen.SelectBuilder;
import com.walker.jdbc.sqlgen.UpdateBuilder;
import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/**
 * 表名:EB_WECHAT_PAY_INFO *
 * @author genrator
 */
public class EbWechatPayInfo_mapper extends EbWechatPayInfo implements BaseMapper<EbWechatPayInfo> {
    // 序列化版本号
    private static final long serialVersionUID = 1L;

    public static final RowMapper<EbWechatPayInfo> ROW_MAPPER = new EbWechatPayInfoRowMapper();

    // 主键
    public static final String Id = "id";
    // 普通属性
    public static final String AppId = "app_id";
    public static final String MchId = "mch_id";
    public static final String DeviceInfo = "device_info";
    public static final String OpenId = "open_id";
    public static final String NonceStr = "nonce_str";
    public static final String Sign = "sign";
    public static final String SignType = "sign_type";
    public static final String Body = "body";
    public static final String Detail = "detail";
    public static final String Attach = "attach";
    public static final String OutTradeNo = "out_trade_no";
    public static final String FeeType = "fee_type";
    public static final String TotalFee = "total_fee";
    public static final String SpbillCreateIp = "spbill_create_ip";
    public static final String TimeStart = "time_start";
    public static final String TimeExpire = "time_expire";
    public static final String NotifyUrl = "notify_url";
    public static final String TradeType = "trade_type";
    public static final String ProductId = "product_id";
    public static final String SceneInfo = "scene_info";
    public static final String ErrCode = "err_code";
    public static final String PrepayId = "prepay_id";
    public static final String CodeUrl = "code_url";
    public static final String IsSubscribe = "is_subscribe";
    public static final String TradeState = "trade_state";
    public static final String BankType = "bank_type";
    public static final String CashFee = "cash_fee";
    public static final String CouponFee = "coupon_fee";
    public static final String TransactionId = "transaction_id";
    public static final String TimeEnd = "time_end";
    public static final String TradeStateDesc = "trade_state_desc";

    /**
     * 默认构造函数
     */
    public EbWechatPayInfo_mapper(EbWechatPayInfo ebWechatPayInfo) {
        if (ebWechatPayInfo == null) {
            throw new IllegalArgumentException("po参数不允许为空！");
        }
        //主键
        if (ebWechatPayInfo.isset_id) {
            this.setId(ebWechatPayInfo.getId());
        }
        //普通属性
        if (ebWechatPayInfo.isset_appId) {
            this.setAppId(ebWechatPayInfo.getAppId());
        }
        if (ebWechatPayInfo.isset_mchId) {
            this.setMchId(ebWechatPayInfo.getMchId());
        }
        if (ebWechatPayInfo.isset_deviceInfo) {
            this.setDeviceInfo(ebWechatPayInfo.getDeviceInfo());
        }
        if (ebWechatPayInfo.isset_openId) {
            this.setOpenId(ebWechatPayInfo.getOpenId());
        }
        if (ebWechatPayInfo.isset_nonceStr) {
            this.setNonceStr(ebWechatPayInfo.getNonceStr());
        }
        if (ebWechatPayInfo.isset_sign) {
            this.setSign(ebWechatPayInfo.getSign());
        }
        if (ebWechatPayInfo.isset_signType) {
            this.setSignType(ebWechatPayInfo.getSignType());
        }
        if (ebWechatPayInfo.isset_body) {
            this.setBody(ebWechatPayInfo.getBody());
        }
        if (ebWechatPayInfo.isset_detail) {
            this.setDetail(ebWechatPayInfo.getDetail());
        }
        if (ebWechatPayInfo.isset_attach) {
            this.setAttach(ebWechatPayInfo.getAttach());
        }
        if (ebWechatPayInfo.isset_outTradeNo) {
            this.setOutTradeNo(ebWechatPayInfo.getOutTradeNo());
        }
        if (ebWechatPayInfo.isset_feeType) {
            this.setFeeType(ebWechatPayInfo.getFeeType());
        }
        if (ebWechatPayInfo.isset_totalFee) {
            this.setTotalFee(ebWechatPayInfo.getTotalFee());
        }
        if (ebWechatPayInfo.isset_spbillCreateIp) {
            this.setSpbillCreateIp(ebWechatPayInfo.getSpbillCreateIp());
        }
        if (ebWechatPayInfo.isset_timeStart) {
            this.setTimeStart(ebWechatPayInfo.getTimeStart());
        }
        if (ebWechatPayInfo.isset_timeExpire) {
            this.setTimeExpire(ebWechatPayInfo.getTimeExpire());
        }
        if (ebWechatPayInfo.isset_notifyUrl) {
            this.setNotifyUrl(ebWechatPayInfo.getNotifyUrl());
        }
        if (ebWechatPayInfo.isset_tradeType) {
            this.setTradeType(ebWechatPayInfo.getTradeType());
        }
        if (ebWechatPayInfo.isset_productId) {
            this.setProductId(ebWechatPayInfo.getProductId());
        }
        if (ebWechatPayInfo.isset_sceneInfo) {
            this.setSceneInfo(ebWechatPayInfo.getSceneInfo());
        }
        if (ebWechatPayInfo.isset_errCode) {
            this.setErrCode(ebWechatPayInfo.getErrCode());
        }
        if (ebWechatPayInfo.isset_prepayId) {
            this.setPrepayId(ebWechatPayInfo.getPrepayId());
        }
        if (ebWechatPayInfo.isset_codeUrl) {
            this.setCodeUrl(ebWechatPayInfo.getCodeUrl());
        }
        if (ebWechatPayInfo.isset_isSubscribe) {
            this.setIsSubscribe(ebWechatPayInfo.getIsSubscribe());
        }
        if (ebWechatPayInfo.isset_tradeState) {
            this.setTradeState(ebWechatPayInfo.getTradeState());
        }
        if (ebWechatPayInfo.isset_bankType) {
            this.setBankType(ebWechatPayInfo.getBankType());
        }
        if (ebWechatPayInfo.isset_cashFee) {
            this.setCashFee(ebWechatPayInfo.getCashFee());
        }
        if (ebWechatPayInfo.isset_couponFee) {
            this.setCouponFee(ebWechatPayInfo.getCouponFee());
        }
        if (ebWechatPayInfo.isset_transactionId) {
            this.setTransactionId(ebWechatPayInfo.getTransactionId());
        }
        if (ebWechatPayInfo.isset_timeEnd) {
            this.setTimeEnd(ebWechatPayInfo.getTimeEnd());
        }
        if (ebWechatPayInfo.isset_tradeStateDesc) {
            this.setTradeStateDesc(ebWechatPayInfo.getTradeStateDesc());
        }
        // 去掉，2022-09-07
        // this.setDatabaseName_(eb_wechat_pay_info.getDatabaseName_());
    }

    /**
     * 获取表名
     */
    @Override
    public String getTableName_() {
        String tableName = "eb_wechat_pay_info";
        /**
        if (StringUtils.isNotEmpty(this.getDatabaseName_())) {
            return this.getDatabaseName_() + "." + tableName;
        } else {
            return tableName;
        }
        */
        return tableName;
    }

    /**
     * 获取主键名称
     */
    @Override
    public String getPkName_() {
        return Id;
    }

    /**
     * 获取主键值
     */
    @Override
    public Object getPkValue_() {
        return this.getId();
    }

    /**
     * 获取插入语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getInsertSql_() {
        InsertBuilder ib = new InsertBuilder(this.getTableName_());
        ib.set(Id, this.getId());
        ib.set(AppId, this.getAppId(), this.isset_appId);
        ib.set(MchId, this.getMchId(), this.isset_mchId);
        ib.set(DeviceInfo, this.getDeviceInfo(), this.isset_deviceInfo);
        ib.set(OpenId, this.getOpenId(), this.isset_openId);
        ib.set(NonceStr, this.getNonceStr(), this.isset_nonceStr);
        ib.set(Sign, this.getSign(), this.isset_sign);
        ib.set(SignType, this.getSignType(), this.isset_signType);
        ib.set(Body, this.getBody(), this.isset_body);
        ib.set(Detail, this.getDetail(), this.isset_detail);
        ib.set(Attach, this.getAttach(), this.isset_attach);
        ib.set(OutTradeNo, this.getOutTradeNo(), this.isset_outTradeNo);
        ib.set(FeeType, this.getFeeType(), this.isset_feeType);
        ib.set(TotalFee, this.getTotalFee(), this.isset_totalFee);
        ib.set(SpbillCreateIp, this.getSpbillCreateIp(), this.isset_spbillCreateIp);
        ib.set(TimeStart, this.getTimeStart(), this.isset_timeStart);
        ib.set(TimeExpire, this.getTimeExpire(), this.isset_timeExpire);
        ib.set(NotifyUrl, this.getNotifyUrl(), this.isset_notifyUrl);
        ib.set(TradeType, this.getTradeType(), this.isset_tradeType);
        ib.set(ProductId, this.getProductId(), this.isset_productId);
        ib.set(SceneInfo, this.getSceneInfo(), this.isset_sceneInfo);
        ib.set(ErrCode, this.getErrCode(), this.isset_errCode);
        ib.set(PrepayId, this.getPrepayId(), this.isset_prepayId);
        ib.set(CodeUrl, this.getCodeUrl(), this.isset_codeUrl);
        ib.set(IsSubscribe, this.getIsSubscribe(), this.isset_isSubscribe);
        ib.set(TradeState, this.getTradeState(), this.isset_tradeState);
        ib.set(BankType, this.getBankType(), this.isset_bankType);
        ib.set(CashFee, this.getCashFee(), this.isset_cashFee);
        ib.set(CouponFee, this.getCouponFee(), this.isset_couponFee);
        ib.set(TransactionId, this.getTransactionId(), this.isset_transactionId);
        ib.set(TimeEnd, this.getTimeEnd(), this.isset_timeEnd);
        ib.set(TradeStateDesc, this.getTradeStateDesc(), this.isset_tradeStateDesc);
        return ib.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_() {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(AppId, this.getAppId(), this.isset_appId);
        ub.set(MchId, this.getMchId(), this.isset_mchId);
        ub.set(DeviceInfo, this.getDeviceInfo(), this.isset_deviceInfo);
        ub.set(OpenId, this.getOpenId(), this.isset_openId);
        ub.set(NonceStr, this.getNonceStr(), this.isset_nonceStr);
        ub.set(Sign, this.getSign(), this.isset_sign);
        ub.set(SignType, this.getSignType(), this.isset_signType);
        ub.set(Body, this.getBody(), this.isset_body);
        ub.set(Detail, this.getDetail(), this.isset_detail);
        ub.set(Attach, this.getAttach(), this.isset_attach);
        ub.set(OutTradeNo, this.getOutTradeNo(), this.isset_outTradeNo);
        ub.set(FeeType, this.getFeeType(), this.isset_feeType);
        ub.set(TotalFee, this.getTotalFee(), this.isset_totalFee);
        ub.set(SpbillCreateIp, this.getSpbillCreateIp(), this.isset_spbillCreateIp);
        ub.set(TimeStart, this.getTimeStart(), this.isset_timeStart);
        ub.set(TimeExpire, this.getTimeExpire(), this.isset_timeExpire);
        ub.set(NotifyUrl, this.getNotifyUrl(), this.isset_notifyUrl);
        ub.set(TradeType, this.getTradeType(), this.isset_tradeType);
        ub.set(ProductId, this.getProductId(), this.isset_productId);
        ub.set(SceneInfo, this.getSceneInfo(), this.isset_sceneInfo);
        ub.set(ErrCode, this.getErrCode(), this.isset_errCode);
        ub.set(PrepayId, this.getPrepayId(), this.isset_prepayId);
        ub.set(CodeUrl, this.getCodeUrl(), this.isset_codeUrl);
        ub.set(IsSubscribe, this.getIsSubscribe(), this.isset_isSubscribe);
        ub.set(TradeState, this.getTradeState(), this.isset_tradeState);
        ub.set(BankType, this.getBankType(), this.isset_bankType);
        ub.set(CashFee, this.getCashFee(), this.isset_cashFee);
        ub.set(CouponFee, this.getCouponFee(), this.isset_couponFee);
        ub.set(TransactionId, this.getTransactionId(), this.isset_transactionId);
        ub.set(TimeEnd, this.getTimeEnd(), this.isset_timeEnd);
        ub.set(TradeStateDesc, this.getTradeStateDesc(), this.isset_tradeStateDesc);
        ub.where(this.getPkName_(), this.getPkValue_());
        return ub.genMapSql();
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getUpdateSql_(String where, Map<String, Object> parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(AppId, this.getAppId(), this.isset_appId);
        ub.set(MchId, this.getMchId(), this.isset_mchId);
        ub.set(DeviceInfo, this.getDeviceInfo(), this.isset_deviceInfo);
        ub.set(OpenId, this.getOpenId(), this.isset_openId);
        ub.set(NonceStr, this.getNonceStr(), this.isset_nonceStr);
        ub.set(Sign, this.getSign(), this.isset_sign);
        ub.set(SignType, this.getSignType(), this.isset_signType);
        ub.set(Body, this.getBody(), this.isset_body);
        ub.set(Detail, this.getDetail(), this.isset_detail);
        ub.set(Attach, this.getAttach(), this.isset_attach);
        ub.set(OutTradeNo, this.getOutTradeNo(), this.isset_outTradeNo);
        ub.set(FeeType, this.getFeeType(), this.isset_feeType);
        ub.set(TotalFee, this.getTotalFee(), this.isset_totalFee);
        ub.set(SpbillCreateIp, this.getSpbillCreateIp(), this.isset_spbillCreateIp);
        ub.set(TimeStart, this.getTimeStart(), this.isset_timeStart);
        ub.set(TimeExpire, this.getTimeExpire(), this.isset_timeExpire);
        ub.set(NotifyUrl, this.getNotifyUrl(), this.isset_notifyUrl);
        ub.set(TradeType, this.getTradeType(), this.isset_tradeType);
        ub.set(ProductId, this.getProductId(), this.isset_productId);
        ub.set(SceneInfo, this.getSceneInfo(), this.isset_sceneInfo);
        ub.set(ErrCode, this.getErrCode(), this.isset_errCode);
        ub.set(PrepayId, this.getPrepayId(), this.isset_prepayId);
        ub.set(CodeUrl, this.getCodeUrl(), this.isset_codeUrl);
        ub.set(IsSubscribe, this.getIsSubscribe(), this.isset_isSubscribe);
        ub.set(TradeState, this.getTradeState(), this.isset_tradeState);
        ub.set(BankType, this.getBankType(), this.isset_bankType);
        ub.set(CashFee, this.getCashFee(), this.isset_cashFee);
        ub.set(CouponFee, this.getCouponFee(), this.isset_couponFee);
        ub.set(TransactionId, this.getTransactionId(), this.isset_transactionId);
        ub.set(TimeEnd, this.getTimeEnd(), this.isset_timeEnd);
        ub.set(TradeStateDesc, this.getTradeStateDesc(), this.isset_tradeStateDesc);
        return ub.genMapSql(where, parameters);
    }

    /**
     * 获取更新语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getUpdateSql_(String where, Object[] parameters) {
        UpdateBuilder ub = new UpdateBuilder(this.getTableName_());
        ub.set(AppId, this.getAppId(), this.isset_appId);
        ub.set(MchId, this.getMchId(), this.isset_mchId);
        ub.set(DeviceInfo, this.getDeviceInfo(), this.isset_deviceInfo);
        ub.set(OpenId, this.getOpenId(), this.isset_openId);
        ub.set(NonceStr, this.getNonceStr(), this.isset_nonceStr);
        ub.set(Sign, this.getSign(), this.isset_sign);
        ub.set(SignType, this.getSignType(), this.isset_signType);
        ub.set(Body, this.getBody(), this.isset_body);
        ub.set(Detail, this.getDetail(), this.isset_detail);
        ub.set(Attach, this.getAttach(), this.isset_attach);
        ub.set(OutTradeNo, this.getOutTradeNo(), this.isset_outTradeNo);
        ub.set(FeeType, this.getFeeType(), this.isset_feeType);
        ub.set(TotalFee, this.getTotalFee(), this.isset_totalFee);
        ub.set(SpbillCreateIp, this.getSpbillCreateIp(), this.isset_spbillCreateIp);
        ub.set(TimeStart, this.getTimeStart(), this.isset_timeStart);
        ub.set(TimeExpire, this.getTimeExpire(), this.isset_timeExpire);
        ub.set(NotifyUrl, this.getNotifyUrl(), this.isset_notifyUrl);
        ub.set(TradeType, this.getTradeType(), this.isset_tradeType);
        ub.set(ProductId, this.getProductId(), this.isset_productId);
        ub.set(SceneInfo, this.getSceneInfo(), this.isset_sceneInfo);
        ub.set(ErrCode, this.getErrCode(), this.isset_errCode);
        ub.set(PrepayId, this.getPrepayId(), this.isset_prepayId);
        ub.set(CodeUrl, this.getCodeUrl(), this.isset_codeUrl);
        ub.set(IsSubscribe, this.getIsSubscribe(), this.isset_isSubscribe);
        ub.set(TradeState, this.getTradeState(), this.isset_tradeState);
        ub.set(BankType, this.getBankType(), this.isset_bankType);
        ub.set(CashFee, this.getCashFee(), this.isset_cashFee);
        ub.set(CouponFee, this.getCouponFee(), this.isset_couponFee);
        ub.set(TransactionId, this.getTransactionId(), this.isset_transactionId);
        ub.set(TimeEnd, this.getTimeEnd(), this.isset_timeEnd);
        ub.set(TradeStateDesc, this.getTradeStateDesc(), this.isset_tradeStateDesc);
        return ub.genArraySql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_() {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        db.where(this.getPkName_(), this.getPkValue_());
        return db.genMapSql();
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getDeleteSql_(String where, Map<String, Object> parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genMapSql(where, parameters);
    }

    /**
     * 获取删除语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getDeleteSql_(String where, Object[] parameters) {
        DeleteBuilder db = new DeleteBuilder(this.getTableName_());
        return db.genArraySql(where, parameters);
    }

    /**
     * 获取单行查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSingleSql_() {
        SelectBuilder sb = new SelectBuilder(this.getTableName_());
        sb.where(this.getPkName_(), this.getPkValue_());
        return sb.genMapSql();
    }


    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Map<String, Object>> getSelectSql_(String where, Map<String, Object> parameters) {
        return new SqlAndParameters<>("select id, app_id, mch_id, device_info, open_id, nonce_str, sign, sign_type, body, detail, attach, out_trade_no, fee_type, total_fee, spbill_create_ip, time_start, time_expire, notify_url, trade_type, product_id, scene_info, err_code, prepay_id, code_url, is_subscribe, trade_state, bank_type, cash_fee, coupon_fee, transaction_id, time_end, trade_state_desc from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 获取查询语句和参数
     */
    @Override
    public SqlAndParameters<Object[]> getSelectSql_(String where, Object[] parameters) {
        return new SqlAndParameters<>("select id, app_id, mch_id, device_info, open_id, nonce_str, sign, sign_type, body, detail, attach, out_trade_no, fee_type, total_fee, spbill_create_ip, time_start, time_expire, notify_url, trade_type, product_id, scene_info, err_code, prepay_id, code_url, is_subscribe, trade_state, bank_type, cash_fee, coupon_fee, transaction_id, time_end, trade_state_desc from " + this.getTableName_() + " " + where, parameters);
    }

    /**
     * 将resultset的一行转化为po
     */
    @Override
    public EbWechatPayInfo mapRow(ResultSet rs, int i) throws SQLException {
        return ROW_MAPPER.mapRow(rs, i);
    }

    /**
     * 克隆
     */
    public EbWechatPayInfo toEbWechatPayInfo() {
        return super.$clone();
    }
}

/**
 * eb_wechat_pay_info RowMapper
 *
 * @author genrator
 */
class EbWechatPayInfoRowMapper implements RowMapper<EbWechatPayInfo> {

    @Override
    public EbWechatPayInfo mapRow(ResultSet rs, int i) throws SQLException {
        ResultSetUtils resultSetUtils = new ResultSetUtils();
        EbWechatPayInfo eb_wechat_pay_info = new EbWechatPayInfo();
        Integer columnIndex;
        //主键
        columnIndex = resultSetUtils.findColumn(rs, EbWechatPayInfo_mapper.Id);
        if (columnIndex > 0) {
            eb_wechat_pay_info.setId(rs.getLong(columnIndex));
        }
        //普通属性
        columnIndex = resultSetUtils.findColumn(rs, EbWechatPayInfo_mapper.AppId);
        if (columnIndex > 0) {
            eb_wechat_pay_info.setAppId(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatPayInfo_mapper.MchId);
        if (columnIndex > 0) {
            eb_wechat_pay_info.setMchId(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatPayInfo_mapper.DeviceInfo);
        if (columnIndex > 0) {
            eb_wechat_pay_info.setDeviceInfo(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatPayInfo_mapper.OpenId);
        if (columnIndex > 0) {
            eb_wechat_pay_info.setOpenId(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatPayInfo_mapper.NonceStr);
        if (columnIndex > 0) {
            eb_wechat_pay_info.setNonceStr(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatPayInfo_mapper.Sign);
        if (columnIndex > 0) {
            eb_wechat_pay_info.setSign(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatPayInfo_mapper.SignType);
        if (columnIndex > 0) {
            eb_wechat_pay_info.setSignType(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatPayInfo_mapper.Body);
        if (columnIndex > 0) {
            eb_wechat_pay_info.setBody(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatPayInfo_mapper.Detail);
        if (columnIndex > 0) {
            eb_wechat_pay_info.setDetail(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatPayInfo_mapper.Attach);
        if (columnIndex > 0) {
            eb_wechat_pay_info.setAttach(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatPayInfo_mapper.OutTradeNo);
        if (columnIndex > 0) {
            eb_wechat_pay_info.setOutTradeNo(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatPayInfo_mapper.FeeType);
        if (columnIndex > 0) {
            eb_wechat_pay_info.setFeeType(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatPayInfo_mapper.TotalFee);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_wechat_pay_info.setTotalFee(null);
            } else {
                eb_wechat_pay_info.setTotalFee(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatPayInfo_mapper.SpbillCreateIp);
        if (columnIndex > 0) {
            eb_wechat_pay_info.setSpbillCreateIp(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatPayInfo_mapper.TimeStart);
        if (columnIndex > 0) {
            eb_wechat_pay_info.setTimeStart(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatPayInfo_mapper.TimeExpire);
        if (columnIndex > 0) {
            eb_wechat_pay_info.setTimeExpire(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatPayInfo_mapper.NotifyUrl);
        if (columnIndex > 0) {
            eb_wechat_pay_info.setNotifyUrl(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatPayInfo_mapper.TradeType);
        if (columnIndex > 0) {
            eb_wechat_pay_info.setTradeType(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatPayInfo_mapper.ProductId);
        if (columnIndex > 0) {
            eb_wechat_pay_info.setProductId(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatPayInfo_mapper.SceneInfo);
        if (columnIndex > 0) {
            eb_wechat_pay_info.setSceneInfo(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatPayInfo_mapper.ErrCode);
        if (columnIndex > 0) {
            eb_wechat_pay_info.setErrCode(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatPayInfo_mapper.PrepayId);
        if (columnIndex > 0) {
            eb_wechat_pay_info.setPrepayId(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatPayInfo_mapper.CodeUrl);
        if (columnIndex > 0) {
            eb_wechat_pay_info.setCodeUrl(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatPayInfo_mapper.IsSubscribe);
        if (columnIndex > 0) {
            eb_wechat_pay_info.setIsSubscribe(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatPayInfo_mapper.TradeState);
        if (columnIndex > 0) {
            eb_wechat_pay_info.setTradeState(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatPayInfo_mapper.BankType);
        if (columnIndex > 0) {
            eb_wechat_pay_info.setBankType(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatPayInfo_mapper.CashFee);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_wechat_pay_info.setCashFee(null);
            } else {
                eb_wechat_pay_info.setCashFee(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatPayInfo_mapper.CouponFee);
        if (columnIndex > 0) {
            if (rs.getBigDecimal(columnIndex) == null) {
                eb_wechat_pay_info.setCouponFee(null);
            } else {
                eb_wechat_pay_info.setCouponFee(rs.getInt(columnIndex));
            }
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatPayInfo_mapper.TransactionId);
        if (columnIndex > 0) {
            eb_wechat_pay_info.setTransactionId(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatPayInfo_mapper.TimeEnd);
        if (columnIndex > 0) {
            eb_wechat_pay_info.setTimeEnd(rs.getString(columnIndex));
        }
        columnIndex = resultSetUtils.findColumn(rs, EbWechatPayInfo_mapper.TradeStateDesc);
        if (columnIndex > 0) {
            eb_wechat_pay_info.setTradeStateDesc(rs.getString(columnIndex));
        }
        return eb_wechat_pay_info;
    }
}
