package com.walker.cache;

import java.io.Serializable;

/**
 * <p/>可缓存对象抽象
 * <p/>系统对于缓存数据统一封装，此接口通常是系统内部使用，对客户端不可见
 * @author MikeShi
 * @date 2012-7-5
 *
 */
public interface Cachable extends Serializable {

	/**
	 * 返回缓存对象的key
	 * @return
	 * @date 2012-7-5
	 */
	String getKey();
	
	/**
	 * 设置缓存对象的key，此key不可重复
	 * @param key
	 * @date 2012-7-5
	 */
	void setKey(String key);
	
	/**
	 * 返回缓存对象实际的值
	 * @return
	 * @date 2012-7-5
	 */
	Object getValue();
	
	/**
	 * 设置缓存对象实际的值
	 * @param value
	 * @date 2012-7-5
	 */
	void setValue(Object value);
	
	/**
	 * 返回对象被使用的次数
	 * @return
	 * @date 2012-7-5
	 */
	int getHit();
	
	/**
	 * 
	 * 对象访问计数，每调用一次计数器加一
	 * @date 2012-7-5
	 */
	void hit();
	
	/**
	 * 返回对象最近的时间戳
	 * @return
	 * @date 2012-7-5
	 */
	long getTimeStamp();
	
	/**
	 * 设置对象时间戳
	 * @param currentMillisecond：以毫秒为基数
	 * @date 2012-7-5
	 */
	void setTimeStamp(long currentMillisecond);
	
	/**
	 * 缓存数据是否过期
	 * @param currentMillis：当前毫秒时间
	 * @param timeOut：设置的过期毫秒数
	 * @return
	 * @date 2012-7-5
	 */
	boolean isExpired(long timeOut, long currentMillis);
}
