package com.walker.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/**
 * 缓存定义对象
 * @author MikeShi
 *
 */
public interface Cache extends Expired, Serializable {

	abstract void put(String key, Object data);

	/**
	 * 带有过期时间的数据存入缓存
	 * @param key
	 * @param data
	 * @param expiredSeconds 过期秒数
	 * @date 2022-11-06
	 */
	abstract void put(String key, Object data, long expiredSeconds);

    void putList(String key, List<Object> list, long expiredSeconds);

    void putListAppend(String key, Object data);

    List<Object> getList(String key, long start, long end, Class<?> clazz);

    void removeList(String key, Object value);

	void removeList(String key);

    long getListSize(String key);

    abstract Object remove(String key);

	abstract void remove(List<String> keys);

	abstract Object get(String key);

	abstract void replace(String key, Object data);

	abstract void clear();

	/**
	 * 更新缓存数据时间戳
	 * @param key
	 * @date 2012-7-5
	 */
	abstract void updateCacheDataTimeStamp(String key);

	String getCacheName();

	void setCacheName(String name);

	/**
	 * 返回在系统关闭时，是否把缓存数据临时写入磁盘，默认否
	 * @return
	 * @date 2012-7-6
	 */
	boolean isWriteOnDiskAfterShutdown();

	/**
	 * 设置在系统关闭时，是否把缓存数据临时写入磁盘
	 * @param boo
	 * @date 2012-7-6
	 */
	void setWriteOnDiskAfterShutdown(boolean boo);

	/**
	 * 返回过期时间：毫秒
	 */
	long getExpiredTime();

	/**
	 * 设置缓存过期时间，单位秒
	 */
	void setExpiredTime(int seconds);

	/**
	 * 返回缓存数据迭代器
	 * @return
	 * @date 2012-7-18
	 */
	Iterator<Cachable> getIterator();

	/**
	 * 设置缓存操作回调接口，用户可以实现该接口在系统操作缓存数据时添加业务操作
	 * @param cacheOperateListener
	 * @date 2012-8-16
	 */
	void setCacheOperateListener(CacheOperateListener cacheOperateListener);

	Object get(String key, Class<?> clazz);

	/**
	 * 获得缓存中的部分keys，注意:当数据量过大时，该方法抛出异常。
	 * @return
	 * @date 2023-01-04
	 */
    Set<Object> getKeys();

    /**
	 * 获取缓存集合列表，注意:该方法在redis缓存中实现。</p>
	 * 如果换成数量过大，会抛出存取异常。
	 * @param clazz
	 * @return
	 */
	List<String> getIterator(Class<?> clazz);

	/**
	 * 返回持久化的的缓存数据数量，如：redis持久的
	 * @return
	 */
	long getPersistentSize();

	Collection<Object> queryListLimit(int maxSize);

	long size();
}
