package com.walker.cache;

/**
 * 系统默认实现的一个缓存数据对象
 * <p/>系统缓存存储的都是这种对象，其中key是业务定义的key，value才是真正业务要存储的数据
 * <p/>
 * @author MikeShi
 *
 */
public class CacheData implements Cachable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 2760771405355406150L;
	
	private String key;
	private Object value;
	private int hits = 0;//数据访问点击率
	private long timeStamp = System.currentTimeMillis();//数据时间戳，可以被系统更新
	
	public int getHit() {
		return hits;
	}

	public String getKey() {
		return key;
	}

	public long getTimeStamp() {
		return timeStamp;
	}

	public Object getValue() {
		return value;
	}

	public void hit() {
		//是否会超过最大值，暂时不做计数
//		hits++;
	}

	public boolean isExpired(long timeOut, long currentMillis) {
		return (currentMillis - timeStamp >= timeOut);
	}

	public void setKey(String key) {
		this.key = key;
	}

	public void setTimeStamp(long currentMillisecond) {
		timeStamp = currentMillisecond;
	}

	public void setValue(Object value) {
		this.value = value;
	}

	public String toString(){
		StringBuilder sb = new StringBuilder();
		sb.append("[key = ");
		sb.append(key);
		sb.append(", value = ");
		sb.append(value);
		sb.append(", hits = ");
		sb.append(hits);
		sb.append(", timeStamp = ");
		sb.append(timeStamp);
		sb.append("]");
		return sb.toString();
	}
	
	public int hashCode(){
		return key.hashCode();
	}
	
	public boolean equals(Object o){
		if(o == null){
			return false;
		}
		if(o == this){
			return true;
		}
		if(o instanceof Cachable){
			Cachable cd = (Cachable)o;
			if(cd.getKey().equals(this.key)){
				return true;
			}
		}
		return false;
	}
}
