package com.walker.cache;

import com.walker.infrastructure.core.ApplicationBeanInitialized;
import com.walker.infrastructure.scheduler.AbstractTimedTask;

import java.util.Iterator;
import java.util.List;

/**
 * 定时清除缓存过期数据任务
 * @author MikeShi
 *
 */
public class CacheExpiredTask extends AbstractTimedTask implements ApplicationBeanInitialized {

	private List<Cache> cacheList;
	
	public void setCacheList(List<Cache> cacheList) {
		this.cacheList = cacheList;
		if(cacheList.size() <= 0){
			this.setPeriod(0);
		}
	}

	@Override
	public void execute() throws Exception {
		logger.debug("//************ 开始执行缓存过期清理任务 ***************");
		startup();
		if(cacheList == null) return;
		
		long currentMillis = System.currentTimeMillis();
		
		//遍历所有系统缓存对象
		for(Cache cache : cacheList){
			Cachable d = null;
			long timeOut = cache.getExpiredTime();
//			logger.debug("缓存 " + cache.getCacheName() + " 超时时间是：" + timeOut);
			
//			List<String> deleteKeys = new LinkedList<String>();
			
			for(Iterator<Cachable> i = cache.getIterator(); i.hasNext();){
				d = i.next();
				if(d.isExpired(timeOut, currentMillis)){
//					deleteKeys.add(d.getKey());
					// 直接通过迭代器删除，不用在标记那些需要删除
					i.remove();
				}
			}
//			cache.remove(deleteKeys);
		}
	}

	public void startup() {
//		if(cacheList == null){
//			cacheList = SystemBeanUtils.getExpiredConfigCaches();
//		}
//		if(cacheList.size() <= 0){
//			this.setPeriod(0);
//		}
	}

}
