package com.walker.cache;

/**
 * 缓存数据操作监听接口
 * <p/>缓存数据变化后会回调该接口
 * @author MikeShi
 *
 */
public interface CacheOperateListener {

	/**
	 * 放入数据时的操作
	 * @param data 放入缓存的原始数据对象
	 * @date 2012-8-16
	 */
	void onPut(Object data);
	
	/**
	 * 删除缓存数据时的操作
	 * @param data 缓存数据的唯一标识
	 * @date 2012-8-16
	 */
	void onRemove(Object data);
	
	/**
	 * 清除缓存数据时的操作
	 * @date 2012-8-16
	 */
	void onClear();
}
