package com.walker.cache;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

/**
 * 处理系统缓存提供者的后处理器实现。</p>
 * 该处理器主要用来实现在启动过程中加载应用定义的缓存bean对象，同时把这些缓存对象<br>
 * 注入到<code>CacheManager</code>中，已在后续运行中提供给应用使用。</p>
 * 搜索的缓存对象包括：
 * <pre>
 * 所有实现<code>CacheProvider</code>的对象。
 * 也包括<code>AbstractCacheTreeProvider</code>它也实现了缓存提供者接口。
 * </pre>
 * @author shikeying
 * @date 2014-8-16
 *
 */
public class CacheProviderPostProcessor implements BeanPostProcessor {

	private final transient Logger logger = LoggerFactory.getLogger(getClass());
	
	@Override
	public Object postProcessAfterInitialization(Object bean, String beanName)
			throws BeansException {
		if(CacheProvider.class.isAssignableFrom(bean.getClass())){
			if(SimpleCacheManager.addCacheProvider((CacheProvider<?>)bean)){
				logger.debug("成功注册缓存对象: " + beanName);
			}
		}
		return bean;
	}

	@Override
	public Object postProcessBeforeInitialization(Object bean, String beanName)
			throws BeansException {
		return bean;
	}

}
