package com.walker.cache;

/**
 * 没有任何可用选项的缓存对象，不支持写磁盘，缓存数据也不会失效。</p>
 * 这适合小数据量的缓存，通常缓存数据不会过万。
 * @author shikeying
 * @date 2013-10-13
 *
 */
public class RigidMemoryCache extends AbstractMemoryCache {

	/**
	 * 
	 */
	private static final long serialVersionUID = 4872865395603939198L;

	public RigidMemoryCache(String name){
		setCacheName(name);
		setExpiredTime(0);
		setWriteOnDiskAfterShutdown(false);
		setCacheOperateListener(null);
	}

}
