package com.walker.cache.tree;

/**
 * 缓存树加载回调接口定义</p>
 * 业务可以根据需要实现回调方法来决定当前缓存节点是否能够被加载到树中。</br>
 * 例如：在组织机构树中，我们可能不想加载那些已经被删除的节点，但是因为这些信息是系统级别的，仍然存在缓存树中，</br>
 * 所以需要业务来确定是否可以被加载。
 * @author shikeying
 *
 */
public interface CacheTreeLoadCallback {

	/**
	 * 决定输入的节点是否能被加载，如果不需要被加载，返回<code>null</code>
	 * @param node 当前获得的缓存树节点对象
	 * @return 需要加载直接返回，不需要返回<code>null</code>
	 */
	CacheTreeNode decide(CacheTreeNode node);
}
