package com.walker.cache.tree;

import java.util.Collection;
import java.util.List;

/**
 * 缓存树节点对象定义
 * @author shikeying
 *
 */
public interface CacheTreeNode extends Comparable<CacheTreeNode> {
	
	String getKey();
	
	String getText();
	
	String getParentId();
	
	void setParentId(String parentId);
	
	/**
	 * 返回原始业务数据，如果没有保留原始业务数据，返回<code>null</code>
	 * @return
	 */
	Object getSource();
	
	int getOrder();
	
	/**
	 * 获得节点图标，如果没有就用默认的
	 * @return
	 */
	String getIcon();
	
	CacheTreeNode setOrder(int orderNum);
	
	boolean hasChild();
	
	int getChildrenSize();
	
	Collection<CacheTreeNode> getChildren();
	
	void addChild(CacheTreeNode node);
	
	/**
	 * 根据给定的key值，找出当前节点下面，子节点中的节点。
	 * @param key 要查找的节点key
	 * @return
	 */
	CacheTreeNode search(String key);
	
	/**
	 * 删除树中某个节点
	 * @param key 节点的ID
	 */
	CacheTreeNode remove(String key);
	
	/**
	 * 把给定的属性克隆（替换）到当前对象中
	 * @param node
	 */
	void cloneProperties(CacheTreeNode node);
	
	/**
	 * 判断节点是否被选择，默认未选择
	 * @return
	 */
	boolean isChecked();
	
	/**
	 * 判断节点是否打开，默认否
	 * @return
	 */
	boolean isOpen();
	
	/**
	 * 设置节点是否被选择
	 * @param bool
	 */
	void setChecked(boolean bool);
	
	/**
	 * 设置节点是否打开
	 * @param bool
	 */
	void setOpen(boolean bool);
	
	void setIcon(String icon);
	
	/**
	 * 简单拷贝，仅复制对象自己内容，不管子节点内容
	 * @return
	 */
	CacheTreeNode copy();

	/**
	 * 搜索树内容，支持模糊查询，返回多个节点
	 * @param keyLike
	 * @return
	 */
	List<CacheTreeNode> searchLike(String keyLike);

	List<CacheTreeNode> searchLike(String[] keyLike);
}
