/*
 * Decompiled with CFR 0.152.
 */
package com.walker.cache;

import com.walker.cache.Cache;
import com.walker.cache.CacheProvider;
import com.walker.cache.RigidMemoryCache;
import com.walker.cache.SimpleCacheManager;
import com.walker.db.page.GenericPager;
import com.walker.infrastructure.utils.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;

public abstract class AbstractCacheProvider<T>
implements CacheProvider<T>,
FactoryBean<CacheProvider<T>> {
    protected static Logger logger = LoggerFactory.getLogger(AbstractCacheProvider.class);
    protected Cache userCache = null;
    protected AtomicLong count = new AtomicLong(0L);
    private boolean loadPage = false;
    private int pageSize = 128;
    private long createTime = 0L;
    private Map<String, String> cacheParam = null;
    private boolean useRedis = false;

    public boolean isUseRedis() {
        return this.useRedis;
    }

    public void setUseRedis(boolean useRedis) {
        this.useRedis = useRedis;
    }

    @Override
    public Map<String, String> getCacheParam() {
        return this.cacheParam;
    }

    public void setCacheParam(Map<String, String> cacheParam) {
        this.cacheParam = cacheParam;
    }

    @Override
    public long getCreateTime() {
        return this.createTime;
    }

    @Override
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public boolean isLoadPage() {
        return this.loadPage;
    }

    @Override
    public void setLoadPage(boolean loadPage) {
        this.loadPage = loadPage;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getProviderType() == null) {
            throw new AbstractMethodError("getProviderType() must be enforced!");
        }
        String name = this.getProviderName();
        if (StringUtils.isEmpty((String)name)) {
            name = String.valueOf(System.currentTimeMillis());
        }
        if (this.userCache != null) {
            this.userCache = null;
        }
        this.userCache = this.provideCacheInstance(name, this.getCacheParam());
        this.createTime = System.currentTimeMillis();
        if (this.isUseRedis()) {
            // empty if block
        }
        if (this.loadPage) {
            GenericPager<T> firstPage = this.loadPageDataToCache(this.userCache, 1, this.pageSize);
            if (firstPage == null) {
                logger.info("...... \u672a\u52a0\u8f7d\u5230\u4efb\u4f55\u4e1a\u52a1\u6570\u636e\u4f5c\u4e3a\u7f13\u5b58\uff0c\u7b2c\u4e00\u9875\u7a7a\uff1a" + this.getProviderName());
                return;
            }
            this.count.set(firstPage.getTotalRows());
            if (this.count.get() > 0L) {
                int pageCount = firstPage.getPageCount();
                logger.info("\u7f13\u5b58 '" + this.getProviderName() + "' \u6570\u636e\u5206\u9875 = " + pageCount);
                if (pageCount > 1) {
                    for (int i = 2; i < pageCount + 1; ++i) {
                        this.loadPageDataToCache(this.userCache, i, this.pageSize);
                        logger.debug("......... \u52a0\u8f7d\u4e86\u4e00\u6b21\u7f13\u5b58\u6570\u636e\uff1a" + i);
                    }
                }
            }
        } else {
            this.count.set(this.loadDataToCache(this.userCache));
        }
        logger.info("cache '" + name + "' loaded size of datas: " + this.count);
    }

    protected Cache provideCacheInstance(String name, Map<String, String> param) {
        return new RigidMemoryCache(name);
    }

    protected abstract int loadDataToCache(Cache var1);

    protected GenericPager<T> loadPageDataToCache(Cache cache, int pageIndex, int pageSize) {
        return null;
    }

    public void destroy() throws Exception {
        if (this.userCache != null) {
            // empty if block
        }
    }

    @Override
    public Cache getCache() {
        if (this.userCache == null) {
            throw new NullPointerException("not found cache: " + this.getProviderName());
        }
        return this.userCache;
    }

    @Override
    public T getCacheData(String key) {
        assert (StringUtils.isNotEmpty((String)key));
        return (T)this.userCache.get(key);
    }

    @Override
    public long getCacheCount() {
        return this.count.get();
    }

    @Override
    public void removeCacheData(String key) {
        this.userCache.remove(key);
        this.count.decrementAndGet();
        if (this.count.get() < 0L) {
            this.count.set(0L);
        }
    }

    @Override
    public void updateCacheData(String key, T data) {
        assert (StringUtils.isNotEmpty((String)key));
        assert (data != null);
        this.userCache.replace(key, data);
    }

    @Override
    public void putCacheData(String key, T data) {
        assert (StringUtils.isNotEmpty((String)key));
        assert (data != null);
        this.userCache.put(key, data);
        this.count.incrementAndGet();
    }

    @Override
    public void putCacheData(String key, T data, long expiredSeconds) {
        assert (StringUtils.isNotEmpty((String)key));
        assert (data != null);
        assert (expiredSeconds > 0L);
        this.userCache.put(key, data, expiredSeconds);
    }

    public String toString() {
        return "cacheName = " + this.getProviderName() + ", cache = " + this.userCache;
    }

    @Override
    public void reload() throws Exception {
        if (this.userCache != null) {
            this.userCache.clear();
            this.userCache = null;
        }
        this.afterPropertiesSet();
    }

    public CacheProvider<T> getObject() throws Exception {
        logger.debug("............\u901a\u8fc7CacheProviderFactoryBean\u83b7\u5f97\u7f13\u5b58\u5bf9\u8c61: " + this.getProviderName());
        SimpleCacheManager.addCacheProvider(this);
        return this;
    }

    public Class<?> getObjectType() {
        return CacheProvider.class;
    }

    public boolean isSingleton() {
        return true;
    }

    @Override
    public long size() {
        return this.userCache.size();
    }

    @Override
    public Collection<Object> queryListLimit(int maxSize) {
        return this.userCache.queryListLimit(maxSize);
    }

    @Override
    public void putCacheList(String key, List<T> data) {
        this.putCacheList(key, data, 0L);
    }

    @Override
    public void putCacheList(String key, List<T> data, long expiredSeconds) {
        if (StringUtils.isEmptyList(data)) {
            throw new IllegalArgumentException("list is required!");
        }
        if (StringUtils.isEmpty((String)key)) {
            throw new IllegalArgumentException("key is required!");
        }
        this.userCache.putList(key, data, expiredSeconds);
    }

    @Override
    public void putCacheListAppend(String key, T data) {
        this.checkKey(key, data);
        this.userCache.putListAppend(key, data);
    }

    @Override
    public List<T> getCacheList(String key) {
        if (StringUtils.isEmpty((String)key)) {
            throw new IllegalArgumentException("key is required!");
        }
        return this.userCache.getList(key, 0L, -1L, this.getProviderType());
    }

    @Override
    public void removeCacheList(String key, T data) {
        this.userCache.removeList(key, data);
    }

    @Override
    public void removeCacheList(String key) {
        this.userCache.removeList(key);
    }

    private void checkKey(String key, T data) {
        if (data == null) {
            throw new IllegalArgumentException("data is required!");
        }
        if (StringUtils.isEmpty((String)key)) {
            throw new IllegalArgumentException("key is required!");
        }
    }
}

