/*
 * Decompiled with CFR 0.152.
 */
package com.walker.cache;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.walker.cache.Cachable;
import com.walker.cache.Cache;
import com.walker.cache.CacheConfig;
import com.walker.cache.CacheData;
import com.walker.cache.CacheOperateListener;
import com.walker.cache.util.KeyUtils;
import com.walker.infrastructure.core.ApplicationBeanDestroied;
import com.walker.infrastructure.core.ApplicationBeanInitialized;
import com.walker.infrastructure.utils.Assert;
import com.walker.infrastructure.utils.ObjectStreamUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMemoryCache
implements Cache,
ApplicationBeanInitialized,
ApplicationBeanDestroied {
    private static final long serialVersionUID = 2575070748765281205L;
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    ConcurrentHashMap<String, Cachable> cacheMap = new ConcurrentHashMap(CacheConfig.INIT_CACHEMAP_SIZE);
    private String cacheName;
    public long expiredTime = 0L;
    private boolean writeOnDiskAfterShutdown = false;
    private CacheOperateListener cacheOperateListener = null;
    private boolean hasCacheListener = false;
    private ConcurrentHashMap<String, List> listMap = new ConcurrentHashMap(CacheConfig.INIT_CACHEMAP_SIZE);

    @Override
    public void setCacheOperateListener(CacheOperateListener cacheOperateListener) {
        if (cacheOperateListener != null) {
            this.hasCacheListener = true;
        }
        this.cacheOperateListener = cacheOperateListener;
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public void setCacheName(String name) {
        this.cacheName = name;
    }

    @Override
    public long getExpiredTime() {
        return this.expiredTime;
    }

    @Override
    public void setExpiredTime(int seconds) {
        this.expiredTime = seconds * 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Cachable> getIterator() {
        ConcurrentHashMap<String, Cachable> concurrentHashMap = this.cacheMap;
        synchronized (concurrentHashMap) {
            return this.cacheMap.values().iterator();
        }
    }

    public void startup() {
        Object obj;
        this.logger.debug("........ execute startup in AbstractMemoryCache! cacheName = " + this.cacheName);
        Assert.isTrue((this.cacheName != null && !this.cacheName.equals("") ? 1 : 0) != 0);
        if (this.writeOnDiskAfterShutdown && (obj = ObjectStreamUtils.readObjectFromFile((String)(CacheConfig.WRITE_TEMP_CACHEFILE + this.cacheName))) != null) {
            this.logger.info("load cache data from disk! cache name: " + this.cacheName);
            this.cacheMap = (ConcurrentHashMap)obj;
        }
    }

    public void shutdown() {
        this.logger.debug("........ execute shutdown in AbstractMemoryCache! cacheName = " + this.cacheName);
        if (this.writeOnDiskAfterShutdown && !this.cacheMap.isEmpty()) {
            ObjectStreamUtils.writeObjectToFile((String)(CacheConfig.WRITE_TEMP_CACHEFILE + this.cacheName), this.cacheMap);
        }
        this.cacheMap.clear();
        this.cacheMap = null;
        this.cacheName = null;
    }

    @Override
    public boolean isWriteOnDiskAfterShutdown() {
        return this.writeOnDiskAfterShutdown;
    }

    @Override
    public void setWriteOnDiskAfterShutdown(boolean boo) {
        this.writeOnDiskAfterShutdown = boo;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[cacheName=");
        sb.append(this.cacheName);
        sb.append(", expiredTime=");
        sb.append(this.expiredTime);
        sb.append(", cacheSize=");
        sb.append(this.cacheMap.size());
        sb.append(", data=");
        sb.append(this.cacheMap);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Object get(String key) {
        Cachable d = this.cacheMap.get(key);
        if (d != null) {
            return d.getValue();
        }
        return null;
    }

    @Override
    public void put(String key, Object data) {
        Assert.notNull((Object)key);
        Assert.notNull((Object)data);
        CacheData cacheData = new CacheData();
        cacheData.setKey(key);
        cacheData.setValue(data);
        this.cacheMap.put(key, cacheData);
        if (this.hasCacheListener) {
            this.cacheOperateListener.onPut(data);
        }
    }

    @Override
    public void put(String key, Object data, long expiredSeconds) {
        throw new UnsupportedOperationException("\u8be5\u65b9\u6cd5\u7531<code>RedisCache</code>\u6216\u8005\u4e1a\u52a1\u81ea\u5b9a\u4e49CacheProvider\u5b9e\u73b0\u3002");
    }

    @Override
    public Object remove(String key) {
        Cachable c = this.cacheMap.remove(key);
        if (c != null) {
            Object v = c.getValue();
            if (this.hasCacheListener) {
                this.cacheOperateListener.onRemove(v);
            }
            return v;
        }
        return null;
    }

    @Override
    public void replace(String key, Object data) {
        Cachable cacheData = this.cacheMap.get(key);
        if (cacheData != null) {
            cacheData.setValue(data);
            cacheData.setTimeStamp(System.currentTimeMillis());
            cacheData.hit();
        }
    }

    @Override
    public void updateCacheDataTimeStamp(String key) {
        Cachable c = this.cacheMap.get(key);
        if (c != null) {
            c.setTimeStamp(System.currentTimeMillis());
            c.hit();
        } else {
            this.logger.warn("updateCacheDataTimeStamp error: cache data not found! key = " + key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(List<String> keys) {
        Assert.notNull(keys);
        ConcurrentHashMap<String, Cachable> concurrentHashMap = this.cacheMap;
        synchronized (concurrentHashMap) {
            for (String key : keys) {
                this.cacheMap.remove(key);
            }
        }
    }

    @Override
    public void clear() {
        this.cacheMap.clear();
        if (this.hasCacheListener) {
            this.cacheOperateListener.onClear();
        }
    }

    @Override
    public Object get(String key, Class<?> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getIterator(Class<?> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getPersistentSize() {
        return 0L;
    }

    @Override
    public long size() {
        return this.cacheMap.size();
    }

    @Override
    public Collection<Object> queryListLimit(int maxSize) {
        if (maxSize < 0 || maxSize >= Integer.MAX_VALUE) {
            return null;
        }
        if (this.cacheMap.size() <= maxSize) {
            ObjectMapper mapper = new ObjectMapper();
            ArrayList<Object> resultList = new ArrayList<Object>(this.cacheMap.size());
            String json = null;
            for (Cachable c : this.cacheMap.values()) {
                try {
                    json = mapper.writeValueAsString(c.getValue());
                    resultList.add(json);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
            return resultList;
        }
        throw new IllegalArgumentException("\u7f13\u5b58\u6570\u91cf\u5927\u4e8e\u7ed9\u5b9a\u7684\u9650\u5236\u503c\uff0c\u4e0d\u80fd\u663e\u793a\u6570\u636e\uff0c\u6570\u91cf\u8fc7\u5927");
    }

    @Override
    public Set<Object> getKeys() {
        HashSet<Object> keyList = new HashSet<Object>();
        Iterator it = ((ConcurrentHashMap.KeySetView)this.cacheMap.keySet()).iterator();
        while (it.hasNext()) {
            keyList.add(it.next());
        }
        return keyList;
    }

    @Override
    public void putList(String key, List<Object> data, long expiredSeconds) {
        this.listMap.put(this.acquireListKey(key), data);
    }

    @Override
    public void putListAppend(String key, Object data) {
        ArrayList<Object> list = this.listMap.get(this.acquireListKey(key));
        if (list == null) {
            list = new ArrayList<Object>();
            this.listMap.put(this.acquireListKey(key), list);
        }
        list.add(data);
    }

    @Override
    public List<Object> getList(String key, long start, long end, Class<?> clazz) {
        return this.listMap.get(this.acquireListKey(key));
    }

    @Override
    public void removeList(String key, Object value) {
        List list = this.listMap.get(this.acquireListKey(key));
        if (list != null) {
            Object obj = null;
            Iterator it = list.iterator();
            while (it.hasNext()) {
                obj = it.next();
                if (!value.equals(obj)) continue;
                it.remove();
            }
        }
    }

    @Override
    public void removeList(String key) {
        this.listMap.remove(this.acquireListKey(key));
    }

    @Override
    public long getListSize(String key) {
        List list = this.listMap.get(this.acquireListKey(key));
        if (list == null) {
            return 0L;
        }
        return list.size();
    }

    private String acquireListKey(String key) {
        return KeyUtils.acquireListKey(this.getCacheName(), key);
    }

    public void print() {
        int size = 2;
        if (this.listMap.size() > 10) {
            this.logger.info("\u5185\u5b58\u4e2d\u5df2\u7ecf\u8d85\u8fc710\u6761\u6570\u636e\uff0c\u603b\u91cf = " + this.listMap.size() + " \u4e2a\u96c6\u5408\uff0c\u53ea\u6253\u5370\u524d10\u6761");
            size = 10;
        }
        int count = 0;
        for (Map.Entry<String, List> entry : this.listMap.entrySet()) {
            if (count > size) break;
            this.logger.info("key = {}, value = {}", (Object)entry.getKey(), (Object)entry.getValue());
            ++count;
        }
    }
}

