/*
 * Decompiled with CFR 0.152.
 */
package com.walker.cache;

import com.walker.cache.Cachable;

public class CacheData
implements Cachable {
    private static final long serialVersionUID = 2760771405355406150L;
    private String key;
    private Object value;
    private int hits = 0;
    private long timeStamp = System.currentTimeMillis();

    @Override
    public int getHit() {
        return this.hits;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void hit() {
    }

    @Override
    public boolean isExpired(long timeOut, long currentMillis) {
        return currentMillis - this.timeStamp >= timeOut;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public void setTimeStamp(long currentMillisecond) {
        this.timeStamp = currentMillisecond;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[key = ");
        sb.append(this.key);
        sb.append(", value = ");
        sb.append(this.value);
        sb.append(", hits = ");
        sb.append(this.hits);
        sb.append(", timeStamp = ");
        sb.append(this.timeStamp);
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object o) {
        Cachable cd;
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        return o instanceof Cachable && (cd = (Cachable)o).getKey().equals(this.key);
    }
}

