/*
 * Decompiled with CFR 0.152.
 */
package com.walker.cache;

import com.walker.cache.Cachable;
import com.walker.cache.Cache;
import com.walker.infrastructure.core.ApplicationBeanInitialized;
import com.walker.infrastructure.scheduler.AbstractTimedTask;
import java.util.Iterator;
import java.util.List;

public class CacheExpiredTask
extends AbstractTimedTask
implements ApplicationBeanInitialized {
    private List<Cache> cacheList;

    public void setCacheList(List<Cache> cacheList) {
        this.cacheList = cacheList;
        if (cacheList.size() <= 0) {
            this.setPeriod(0L);
        }
    }

    public void execute() throws Exception {
        this.logger.debug("//************ \u5f00\u59cb\u6267\u884c\u7f13\u5b58\u8fc7\u671f\u6e05\u7406\u4efb\u52a1 ***************");
        this.startup();
        if (this.cacheList == null) {
            return;
        }
        long currentMillis = System.currentTimeMillis();
        for (Cache cache : this.cacheList) {
            Cachable d = null;
            long timeOut = cache.getExpiredTime();
            Iterator<Cachable> i = cache.getIterator();
            while (i.hasNext()) {
                d = i.next();
                if (!d.isExpired(timeOut, currentMillis)) continue;
                i.remove();
            }
        }
    }

    public void startup() {
    }
}

