/*
 * Decompiled with CFR 0.152.
 */
package com.walker.cache;

import com.walker.cache.CacheProvider;
import com.walker.cache.tree.CacheTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimpleCacheManager {
    private static final transient Logger logger = LoggerFactory.getLogger(SimpleCacheManager.class);
    private static boolean initialized = false;
    private static final Object lock = new Object();
    private static final Map<Class<?>, CacheProvider<?>> cacheProvidersMap = new ConcurrentHashMap();
    private static final Map<String, CacheProvider<?>> cacheProvidersNameMap = new ConcurrentHashMap();

    private SimpleCacheManager() {
    }

    public static final CacheProvider<?> getCacheProvider(String cacheProviderName) {
        CacheProvider<?> cp = cacheProvidersNameMap.get(cacheProviderName);
        if (cp == null) {
            throw new NullPointerException("not found cacheProvider: " + cacheProviderName);
        }
        return cp;
    }

    public static final <T> CacheProvider<T> getCacheProvider(Class<T> clazz) {
        CacheProvider<?> cp = cacheProvidersMap.get(clazz);
        if (cp == null) {
            throw new NullPointerException("not found cacheProvider: " + clazz.getName());
        }
        return cp;
    }

    public static final <T> CacheTree<T> getCacheTreeProvider(Class<T> clazz) {
        CacheProvider<T> cp = SimpleCacheManager.getCacheProvider(clazz);
        if (CacheTree.class.isAssignableFrom(cp.getClass())) {
            return (CacheTree)cp;
        }
        throw new UnsupportedOperationException(clazz.getName() + " is not a CacheTree!");
    }

    @Deprecated
    public static final Collection<CacheProvider<?>> getCacheProviders() {
        if (cacheProvidersMap.size() == 0) {
            return null;
        }
        return cacheProvidersMap.values();
    }

    public static final List<CacheProvider<?>> getCacheProviderList() {
        ArrayList data = new ArrayList();
        for (CacheProvider<?> cp : cacheProvidersNameMap.values()) {
            data.add(cp);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheProviders(List<CacheProvider<?>> cacheProviders) {
        if (cacheProviders == null) {
            return;
        }
        if (!initialized) {
            Object object = lock;
            synchronized (object) {
                try {
                    for (CacheProvider<?> cp : cacheProviders) {
                        cacheProvidersMap.put(cp.getProviderType(), cp);
                        cacheProvidersNameMap.put(cp.getProviderName(), cp);
                    }
                    initialized = true;
                }
                catch (Throwable cause) {
                    throw new Error("\u521d\u59cb\u5316\u7cfb\u7edf\u7f13\u5b58\u5931\u8d25\u3002", cause);
                }
            }
        }
    }

    public static final boolean addCacheProvider(CacheProvider<?> cacheProvider) {
        assert (cacheProvider != null);
        if (!cacheProvidersMap.containsKey(cacheProvider.getProviderType())) {
            cacheProvidersMap.put(cacheProvider.getProviderType(), cacheProvider);
            cacheProvidersNameMap.put(cacheProvider.getProviderName(), cacheProvider);
            return true;
        }
        cacheProvidersNameMap.put(cacheProvider.getProviderName(), cacheProvider);
        logger.debug("\u5df2\u7ecf\u5b58\u5728\u4e86\u7f13\u5b58\u5bf9\u8c61\uff0c\u4e0d\u80fd\u91cd\u590d\u6ce8\u518c: " + cacheProvider.getProviderType() + ", cacheName=" + cacheProvider.getProviderName());
        return false;
    }
}

