/*
 * Decompiled with CFR 0.152.
 */
package com.walker.cache.tree;

import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cachable;
import com.walker.cache.Cache;
import com.walker.cache.tree.CacheTree;
import com.walker.cache.tree.CacheTreeNode;
import com.walker.cache.tree.DefaultCacheTreeNode;
import com.walker.infrastructure.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractCacheTreeProvider<T>
extends AbstractCacheProvider<T>
implements CacheTree<T> {
    public static final String SUPER_ROOT_KEY = "cacheTree_super_root_key";

    @Override
    public List<String> getRootKeys() {
        CacheTreeNode node = this.get(SUPER_ROOT_KEY);
        if (node != null) {
            Collection<CacheTreeNode> rootList = node.getChildren();
            if (rootList == null || rootList.size() == 0) {
                return null;
            }
            ArrayList<String> result = new ArrayList<String>(rootList.size());
            if (rootList != null) {
                Iterator<CacheTreeNode> i = rootList.iterator();
                while (i.hasNext()) {
                    result.add(i.next().getKey());
                }
                return result;
            }
        }
        return null;
    }

    @Override
    public Collection<CacheTreeNode> getRootList() {
        CacheTreeNode node = this.get(SUPER_ROOT_KEY);
        if (node != null) {
            return node.getChildren();
        }
        return null;
    }

    @Override
    public CacheTreeNode getOneRootNode(String key) {
        return this.searchTreeNode(key);
    }

    @Override
    public CacheTreeNode searchTreeNode(String key) {
        assert (StringUtils.isNotEmpty((String)key));
        CacheTreeNode node = this.get(SUPER_ROOT_KEY);
        if (node != null) {
            return node.search(key);
        }
        return null;
    }

    public List<CacheTreeNode> searchTreeNodeList(String keyLike) {
        CacheTreeNode node = this.get(SUPER_ROOT_KEY);
        if (node != null) {
            return node.searchLike(keyLike);
        }
        return null;
    }

    public List<CacheTreeNode> searchTreeNodeList(String[] keys) {
        CacheTreeNode node = this.get(SUPER_ROOT_KEY);
        if (node != null) {
            return node.searchLike(keys);
        }
        return null;
    }

    @Override
    protected int loadDataToCache(Cache cache) {
        try {
            Map<String, CacheTreeNode> rootMap = this.loadRootList();
            if (rootMap == null || rootMap.size() == 0) {
                logger.info("no root cache loaded in '" + this.getProviderName() + "'.");
                cache.put(SUPER_ROOT_KEY, this.createSuperRoot());
                return 0;
            }
            Map<String, CacheTreeNode> childMap = this.loadChildList();
            this.addListToCache(rootMap.values().iterator(), cache);
            if (childMap != null && childMap.size() > 0) {
                this.mountTree(childMap, cache);
            }
            CacheTreeNode superRoot = this.createSuperRoot();
            Iterator<Cachable> i = cache.getIterator();
            while (i.hasNext()) {
                superRoot.addChild((CacheTreeNode)i.next().getValue());
            }
            cache.clear();
            cache.put(SUPER_ROOT_KEY, superRoot);
            int total = rootMap.size();
            this.addListToCache(rootMap.values().iterator(), cache);
            if (childMap != null) {
                this.addListToCache(childMap.values().iterator(), cache);
                total += childMap.size();
            }
            return total;
        }
        catch (Exception ex) {
            throw new Error("failed to loading user cache:" + this.getProviderName(), ex);
        }
    }

    private CacheTreeNode createSuperRoot() {
        return new DefaultCacheTreeNode(SUPER_ROOT_KEY, "superRoot", null, null);
    }

    private void mountTree(Map<String, CacheTreeNode> childMap, Cache cache) {
        CacheTreeNode _node2 = null;
        for (CacheTreeNode _node2 : childMap.values()) {
            this.mountMiddleNode(_node2, childMap, cache);
        }
    }

    private void mountMiddleNode(CacheTreeNode currentNode, Map<String, CacheTreeNode> childMap, Cache cache) {
        CacheTreeNode _parentNode = (CacheTreeNode)cache.get(currentNode.getParentId());
        if (_parentNode == null) {
            _parentNode = childMap.get(currentNode.getParentId());
            if (_parentNode == null) {
                throw new NullPointerException("parent node not found, current: " + currentNode);
            }
            _parentNode.addChild(currentNode);
            this.mountMiddleNode(_parentNode, childMap, cache);
        } else if (this.parentIsRoot(_parentNode.getParentId())) {
            _parentNode.addChild(currentNode);
        }
    }

    private void addListToCache(Iterator<CacheTreeNode> iterator, Cache cache) {
        Iterator<CacheTreeNode> i = iterator;
        while (i.hasNext()) {
            this.addObjectToCache(i.next(), cache);
        }
    }

    private void addObjectToCache(CacheTreeNode node, Cache cache) {
        assert (node != null && node.getSource() != null);
        cache.put(node.getKey(), node);
    }

    protected abstract Map<String, CacheTreeNode> loadRootList();

    protected abstract Map<String, CacheTreeNode> loadChildList();

    protected abstract CacheTreeNode toCacheTreeNode(T var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void putCacheData(String key, T data) {
        CacheTreeNode node = this.toCacheTreeNode(data);
        if (node == null) {
            throw new AbstractMethodError();
        }
        CacheTreeNode vRoot = this.get(SUPER_ROOT_KEY);
        if (vRoot == null) throw new NullPointerException("not found virtual Root in '" + this.getProviderName() + "'.");
        if (StringUtils.isEmpty((String)node.getParentId()) || this.parentIsRoot(node.getParentId())) {
            vRoot.addChild(node);
        } else {
            CacheTreeNode _parent = vRoot.search(node.getParentId());
            if (_parent == null) throw new NullPointerException("not found parent in node: " + node);
            _parent.addChild(node);
        }
        this.getCache().put(key, node);
    }

    @Override
    public void removeCacheData(String key) {
        this.getCache().remove(key);
        CacheTreeNode vRoot = this.get(SUPER_ROOT_KEY);
        if (vRoot != null && StringUtils.isNotEmpty((String)key)) {
            CacheTreeNode removed = vRoot.remove(key);
            logger.debug("removed CacheTreeNode: " + removed);
        }
    }

    @Override
    public void updateCacheData(String key, T data) {
        CacheTreeNode oldNode;
        assert (StringUtils.isNotEmpty((String)key));
        assert (data != null);
        CacheTreeNode node = this.toCacheTreeNode(data);
        if (node == null) {
            throw new AbstractMethodError();
        }
        this.getCache().replace(key, node);
        CacheTreeNode vRoot = this.get(SUPER_ROOT_KEY);
        if (vRoot != null && (oldNode = vRoot.search(key)) != null) {
            oldNode.cloneProperties(node);
        }
    }

    @Override
    public T getCacheData(String key) {
        assert (StringUtils.isNotEmpty((String)key));
        CacheTreeNode node = this.get(key);
        if (node != null && node.getSource() != null) {
            return (T)node.getSource();
        }
        return null;
    }

    @Override
    public CacheTreeNode get(String key) {
        return (CacheTreeNode)this.getCache().get(key);
    }

    private boolean parentIsRoot(String parentId) {
        return parentId.equalsIgnoreCase("root") || parentId.equals("0");
    }
}

