/*
 * Decompiled with CFR 0.152.
 */
package com.walker.cache.tree;

import com.walker.cache.tree.CacheTreeNode;
import com.walker.cache.tree.DefaultCacheTreeNode;
import com.walker.infrastructure.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class AbstractTreeGenerator<T> {
    private boolean multiRoot = false;
    private CacheTreeNode dummyRoot = null;
    private Map<String, CacheTreeNode> rootMap = new TreeMap<String, CacheTreeNode>();
    private Map<String, CacheTreeNode> childMap = new TreeMap<String, CacheTreeNode>();

    public AbstractTreeGenerator(String dummyRootName) {
        if (StringUtils.isNotEmpty((String)dummyRootName)) {
            this.dummyRoot = new DefaultCacheTreeNode("root", dummyRootName, null, "0");
        }
    }

    public CacheTreeNode getTreeRoot() {
        if (this.multiRoot) {
            throw new IllegalStateException("\u5b58\u5728\u591a\u4e2a\u6839\u8282\u70b9\uff0c\u8bf7\u8c03\u7528\u65b9\u6cd5:getTreeRootList().");
        }
        if (this.dummyRoot != null) {
            return this.dummyRoot;
        }
        return this.rootMap.values().iterator().next();
    }

    public List<CacheTreeNode> getTreeRootList() {
        if (!this.multiRoot) {
            throw new IllegalStateException("\u5b58\u5728\u591a\u4e2a\u6839\u8282\u70b9\uff0c\u8bf7\u8c03\u7528\u65b9\u6cd5:getTreeRoot().");
        }
        ArrayList<CacheTreeNode> list = new ArrayList<CacheTreeNode>();
        for (CacheTreeNode node : this.rootMap.values()) {
            list.add(node);
        }
        return list;
    }

    public void setMultiRoot(boolean multiRoot) {
        this.multiRoot = multiRoot;
    }

    public void setEntityList(List<T> datas) {
        if (StringUtils.isEmptyList(datas)) {
            return;
        }
        CacheTreeNode node = null;
        for (T obj : datas) {
            node = this.toCacheTreeNode(obj);
            if (StringUtils.isNotEmpty((String)node.getParentId()) && this.parentIsRoot(node.getParentId())) {
                this.rootMap.put(node.getKey(), node);
                continue;
            }
            this.childMap.put(node.getKey(), node);
        }
        if (this.rootMap.size() == 0) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u6839\u8282\u70b9\u3002");
        }
        if (this.childMap != null && this.childMap.size() > 0) {
            this.mountTree(this.childMap);
        }
        if (this.dummyRoot != null) {
            for (CacheTreeNode n : this.rootMap.values()) {
                n.setParentId("root");
                this.dummyRoot.addChild(n);
            }
        }
    }

    public void destroy() {
        this.dummyRoot = null;
        this.rootMap.clear();
        this.childMap.clear();
    }

    protected abstract CacheTreeNode toCacheTreeNode(T var1);

    private boolean parentIsRoot(String parentId) {
        return parentId.equalsIgnoreCase("root") || parentId.equals("0");
    }

    private void mountTree(Map<String, CacheTreeNode> childMap) {
        CacheTreeNode _node2 = null;
        for (CacheTreeNode _node2 : childMap.values()) {
            this.mountMiddleNode(_node2, childMap);
        }
    }

    private void mountMiddleNode(CacheTreeNode currentNode, Map<String, CacheTreeNode> childMap) {
        CacheTreeNode _parentNode = this.rootMap.get(currentNode.getParentId());
        if (_parentNode == null) {
            _parentNode = childMap.get(currentNode.getParentId());
            if (_parentNode == null) {
                throw new NullPointerException("parent node not found, current: " + currentNode);
            }
            _parentNode.addChild(currentNode);
            this.mountMiddleNode(_parentNode, childMap);
        } else if (this.parentIsRoot(_parentNode.getParentId())) {
            _parentNode.addChild(currentNode);
        }
    }
}

