/*
 * Decompiled with CFR 0.152.
 */
package com.walker.cache.tree;

import com.walker.cache.tree.CacheTreeNode;
import com.walker.infrastructure.utils.Assert;
import com.walker.infrastructure.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class DefaultCacheTreeNode
implements CacheTreeNode {
    protected String key;
    protected String text;
    protected Object source;
    private String parentId;
    private int order = 0;
    protected TreeMap<String, CacheTreeNode> children = new TreeMap();
    private boolean checked = false;
    private boolean opened = false;
    private String icon = null;

    public DefaultCacheTreeNode(String key, String text, Object source, String parentId) {
        assert (StringUtils.isNotEmpty((String)key));
        assert (StringUtils.isNotEmpty((String)text));
        this.key = key;
        this.text = text;
        this.source = source;
        if (StringUtils.isNotEmpty((String)parentId)) {
            this.parentId = parentId;
        }
    }

    public DefaultCacheTreeNode(String key, String text, Object source, String parentId, int orderNum) {
        this(key, text, source, parentId);
        this.order = orderNum;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    @Override
    public boolean hasChild() {
        return this.children.size() > 0;
    }

    @Override
    public int getChildrenSize() {
        return this.children.size();
    }

    @Override
    public Collection<CacheTreeNode> getChildren() {
        if (this.hasChild()) {
            return this.children.values();
        }
        return null;
    }

    @Override
    public CacheTreeNode search(String key) {
        if (StringUtils.isEmpty((String)key)) {
            return null;
        }
        if (this.key.equals(key)) {
            return this;
        }
        if (!this.hasChild()) {
            return null;
        }
        CacheTreeNode child = null;
        Iterator<CacheTreeNode> i = this.children.values().iterator();
        while (i.hasNext()) {
            child = i.next().search(key);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    @Override
    public List<CacheTreeNode> searchLike(String keyLike) {
        if (StringUtils.isEmpty((String)keyLike)) {
            return null;
        }
        ArrayList<CacheTreeNode> list = new ArrayList<CacheTreeNode>(8);
        if (this.key.indexOf(keyLike) >= 0 || this.text.indexOf(keyLike) >= 0) {
            list.add(this);
        }
        if (this.hasChild()) {
            List<CacheTreeNode> child = null;
            Iterator<CacheTreeNode> i = this.children.values().iterator();
            while (i.hasNext()) {
                child = i.next().searchLike(keyLike);
                if (child == null) continue;
                list.addAll(child);
            }
        }
        return list;
    }

    @Override
    public List<CacheTreeNode> searchLike(String[] keys) {
        if (keys == null) {
            return null;
        }
        ArrayList<CacheTreeNode> list = new ArrayList<CacheTreeNode>(8);
        if (this.containKeyLike(this.key, keys) || this.containKeyLike(this.text, keys)) {
            list.add(this);
        }
        if (this.hasChild()) {
            List<CacheTreeNode> child = null;
            Iterator<CacheTreeNode> i = this.children.values().iterator();
            while (i.hasNext()) {
                child = i.next().searchLike(keys);
                if (child == null) continue;
                list.addAll(child);
            }
        }
        return list;
    }

    private boolean containKeyLike(String content, String[] keys) {
        for (String k : keys) {
            if (content.indexOf(k) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addChild(CacheTreeNode node) {
        if (node != null && this.search(node.getKey()) == null) {
            this.children.put(node.getKey(), node);
        }
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("{key = ").append(this.key).append(", text = ").append(this.text).append(", parentId = ").append(this.parentId).append(", order = ").append(this.order);
        sb.append(",[");
        for (CacheTreeNode node : this.children.values()) {
            sb.append(node.getKey());
            sb.append(":");
            sb.append(node.getText());
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public CacheTreeNode remove(String key) {
        if (StringUtils.isEmpty((String)key)) {
            return null;
        }
        if (!this.hasChild()) {
            return null;
        }
        CacheTreeNode removed = this.children.remove(key);
        if (removed != null) {
            return removed;
        }
        Iterator<CacheTreeNode> i = this.children.values().iterator();
        while (i.hasNext()) {
            removed = i.next().remove(key);
            if (removed == null) continue;
            return removed;
        }
        return null;
    }

    @Override
    public void cloneProperties(CacheTreeNode node) {
        this.text = node.getText();
        this.source = node.getSource();
        this.order = node.getOrder();
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public CacheTreeNode setOrder(int orderNum) {
        this.order = orderNum;
        return this;
    }

    @Override
    public int compareTo(CacheTreeNode o) {
        if (o == null) {
            return 1;
        }
        if (this == o) {
            return 0;
        }
        if (this.order > o.getOrder()) {
            return 1;
        }
        if (this.order < o.getOrder()) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean isChecked() {
        return this.checked;
    }

    @Override
    public boolean isOpen() {
        return this.opened;
    }

    @Override
    public void setChecked(boolean bool) {
        this.checked = bool;
    }

    @Override
    public void setOpen(boolean bool) {
        this.opened = bool;
    }

    @Override
    public void setParentId(String parentId) {
        Assert.hasText((String)parentId);
        this.parentId = parentId;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Override
    public CacheTreeNode copy() {
        DefaultCacheTreeNode newObject = new DefaultCacheTreeNode(this.key, this.text, this.source, this.parentId);
        newObject.setIcon(this.icon);
        return newObject.setOrder(this.order);
    }
}

