package com.walker.connector;

import com.walker.jdbc.util.StringSqlUtils;
import com.walker.jdbc.util.StringUtils;

/**
 * 定义数据库地址对象，也可以用于普通HTTP地址形势。不过目前主要在数据库采集模块中使用。
 * @author 时克英
 * @date 2022-09-09
 */
public class Address {
    private String url;
    private int port = 0;
    // 服务字符串，mysql中可能带有参数，如：walkersoft?encode=utf8
    private String service = StringUtils.EMPTY_STRING;
    // 服务名字，去掉了?参数信息，mysql会出现此情况
    private String serviceName = StringUtils.EMPTY_STRING;
    private String authentication;
    private String certification;

    private boolean using = false; // 是否正在使用
    private boolean used = false;  // 此库是否被使用过
    private int suffixIndex = 1; // 多个资源库时，后缀编号

    private int type = 1;

    private String id;

    /**
     * id对应数据库表中数据源主键，后追加
     * @date 2019-05-10
     * @return
     */
    public String getId() {
        return id;
    }
    public void setId(String id) {
        this.id = id;
    }
    /**
     * 该字段表示数据库类型
     * @return
     * @author 时克英
     * @date 2019-05-10
     */
    public int getType() {
        return type;
    }
    public void setType(int type) {
        this.type = type;
    }
    public boolean isUsed() {
        return used;
    }
    public void setUsed(boolean used) {
        this.used = used;
    }

    public boolean isUsing() {
        return using;
    }
    public void setUsing(boolean use) {
        this.using = use;
    }
    public int getSuffixIndex() {
        return suffixIndex;
    }
    public void setSuffixIndex(int suffixIndex) {
        this.suffixIndex = suffixIndex;
    }
    public String getUrl() {
        return url;
    }
    public void setUrl(String url) {
        this.url = url;
    }
    public int getPort() {
        return port;
    }
    public void setPort(int port) {
        this.port = port;
    }

    /**
     * 返回服务名称，如：数据库名称，目录文件夹等
     * @return
     */
    @Deprecated
    public String getService() {
        return service;
    }

    /**
     * 返回服务真正名字，去掉参数。因为在mysql中可能带有参数，如：walkersoft?encode=utf8
     * @return
     */
    public String getServiceName(){
        return serviceName;
    }
    public void setService(String service) {
        this.service = service;
        this.serviceName = StringSqlUtils.getMySQLSchemaName(service);
    }

    /**
     * 返回认证信息，如：用户名
     * @return
     */
    public String getAuthentication() {
        return authentication;
    }
    public void setAuthentication(String authentication) {
        this.authentication = authentication;
    }

    /**
     * 返回认证凭证，如：密码等
     * @return
     */
    public String getCertification() {
        return certification;
    }
    public void setCertification(String certification) {
        this.certification = certification;
    }

    @Override
    public boolean equals(Object obj){
        if(obj != null && obj instanceof Address){
            Address address = (Address)obj;
            if(address.url.equals(this.url)
                    && address.port == this.port
                    && address.serviceName.equals(this.serviceName)){
                return true;
            }
        }
        return false;
    }

    private int hashCode = 0;

    @Override
    public int hashCode(){
        if(hashCode == 0){
            hashCode = 31 + url.hashCode() + serviceName.hashCode() + port;
        }
        return hashCode;
    }

    @Override
    public String toString(){
        return new StringBuilder().append("address:[url=").append(url)
                .append(", port=").append(port)
                .append(", serviceName=").append(serviceName)
                .append(", suffixIndex=").append(suffixIndex)
                .append(", service=").append(service)
                .append("]").toString();
    }

    private int maxActive = 6;
    private int initSize = 3;
    private int maxIdle = 3;

    public int getMaxActive() {
        return maxActive;
    }
    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }
    public int getInitSize() {
        return initSize;
    }
    public void setInitSize(int initSize) {
        this.initSize = initSize;
    }
    public int getMaxIdle() {
        return maxIdle;
    }
    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

}
