/*
 * Decompiled with CFR 0.152.
 */
package com.walker.connector.db;

import com.walker.connector.support.DatabaseConnector;
import com.walker.db.DatabaseType;
import com.walker.db.TableInfo;
import com.walker.jdbc.util.StringSqlUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class MySqlConnector
extends DatabaseConnector {
    public static final String SQL_TABLES_ROW = "SELECT TABLE_NAME tname, TABLE_COMMENT summary, TABLE_ROWS trows FROM information_schema.`TABLES`  WHERE TABLE_SCHEMA = :schema AND TABLE_TYPE = 'BASE TABLE' AND TABLE_NAME in (:ids)";

    @Override
    protected DatabaseType getDatabaseType() {
        return DatabaseType.MYSQL;
    }

    public MySqlConnector() {
    }

    public MySqlConnector(DataSource dataSource) {
        super(dataSource);
    }

    public static void main(String[] args) {
        MySqlConnector dbConnector = new MySqlConnector();
        dbConnector.setUrl("127.0.0.1");
        dbConnector.setPort(3307);
        dbConnector.setServiceName("ecard_dist_1?characterEncoding=UTF-8");
        HashMap<String, String> parameters = new HashMap<String, String>(5);
        parameters.put("user", "root");
        parameters.put("password", "123456");
        parameters.put("maxActive", "5");
        parameters.put("maxIdle", "2");
        parameters.put("initialSize", "2");
        dbConnector.setParameters(parameters);
        dbConnector.initialize();
        try {
            TableInfoMapper tableInfoMapper = new TableInfoMapper();
            ArrayList<String> tables = new ArrayList<String>();
            tables.add("base_area_44");
            tables.add("rec_main_consume_856");
            String repoName = StringSqlUtils.getMySQLSchemaName((String)dbConnector.getServiceName());
            System.out.println("serviceName: " + repoName);
            MapSqlParameterSource nameSet = new MapSqlParameterSource();
            nameSet.addValue("schema", (Object)repoName);
            nameSet.addValue("ids", tables);
            List<TableInfo> list = dbConnector.queryForRowMapper(SQL_TABLES_ROW, tableInfoMapper, (SqlParameterSource)nameSet);
            for (TableInfo ti : list) {
                System.out.println(ti);
            }
            System.out.println("=================");
        }
        catch (Exception e) {
            if (e.getCause() instanceof SQLException) {
                System.out.println("\u6570\u636e\u5e93\u5df2\u7ecf\u5b58\u5728\uff0c\u6216\u8005\u6ca1\u6709\u6743\u9650\u8bbf\u95ee");
            }
            e.printStackTrace();
        }
    }

    private static class TableInfoMapper
    implements RowMapper<TableInfo> {
        private TableInfoMapper() {
        }

        public TableInfo mapRow(ResultSet rs, int arg1) throws SQLException {
            TableInfo ti = new TableInfo();
            ti.setName(rs.getString("tname"));
            ti.setSummary(rs.getString("summary"));
            ti.setRows(rs.getLong("trows"));
            return ti;
        }
    }
}

