/*
 * Decompiled with CFR 0.152.
 */
package com.walker.connector.support;

import com.walker.connector.AbstractConnector;
import com.walker.db.DatabaseException;
import com.walker.db.DatabaseExistException;
import com.walker.db.DatabaseType;
import com.walker.db.page.GenericPager;
import com.walker.db.page.ListPageContext;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.ds.MyDruidDataSource;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public abstract class DatabaseConnector
extends AbstractConnector {
    public static final String OPTION_USER = "user";
    public static final String OPTION_PASSWORD = "password";
    public static final String OPTION_MAX_ACTIVE = "maxActive";
    public static final String OPTION_MAX_IDLE = "maxIdle";
    public static final String OPTION_INIT_SIZE = "initialSize";
    public static final String SQL_CREATE_DB_PREF = "CREATE DATABASE ";
    public static final String SQL_CREATE_DB_SUF = " DEFAULT CHARSET utf8 COLLATE utf8_general_ci;";
    protected JdbcTemplate jdbcTemplate = null;
    protected NamedParameterJdbcTemplate namedJdbcTemplate;
    private boolean manageMode = false;
    private DataSource dataSource = null;

    public DatabaseConnector() {
    }

    public DatabaseConnector(DataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException("dataSource\u5fc5\u987b\u8bbe\u7f6e!");
        }
        this.dataSource = dataSource;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.namedJdbcTemplate = new NamedParameterJdbcTemplate(dataSource);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public NamedParameterJdbcTemplate getNamedJdbcTemplate() {
        return this.namedJdbcTemplate;
    }

    public boolean isManageMode() {
        return this.manageMode;
    }

    public void setManageMode() {
        this.manageMode = true;
        this.setServiceName("");
    }

    public void exeCreateDatabase(String databaseName) throws DatabaseException {
        try {
            this.jdbcTemplate.execute(SQL_CREATE_DB_PREF + databaseName + SQL_CREATE_DB_SUF);
        }
        catch (DataAccessException ex) {
            SQLException sqlEx = (SQLException)ex.getRootCause();
            if (sqlEx.getErrorCode() == 1007) {
                throw new DatabaseExistException(databaseName);
            }
            throw new DatabaseException("createDatabase\u5f02\u5e38", (Throwable)ex);
        }
    }

    public void exeCreateTable(String sql) throws DatabaseException {
        try {
            this.jdbcTemplate.execute(sql);
            this.logger.debug("\u6267\u884c\u521b\u5efa\u8868SQL = " + sql);
        }
        catch (DataAccessException ex) {
            throw new DatabaseException("createTable\u5f02\u5e38", (Throwable)ex);
        }
    }

    public int execBatchInsert(String sql, MapSqlParameterSource[] spsArray) {
        int[] res = this.namedJdbcTemplate.batchUpdate(sql, (SqlParameterSource[])spsArray);
        return res[0];
    }

    public void execBatchUpdateForJdbc(String sql, List<Object[]> batchArgs) {
        this.jdbcTemplate.batchUpdate(sql, batchArgs);
    }

    public void execute(String sql) throws DatabaseException {
        try {
            this.jdbcTemplate.execute(sql);
        }
        catch (DataAccessException ex) {
            throw new DatabaseException("execute(sql)\u5f02\u5e38", (Throwable)ex);
        }
    }

    public List<Map<String, Object>> queryForList(String sql, Object[] args) {
        return this.getJdbcTemplate().queryForList(sql, args);
    }

    public <T> List<T> queryForRowMapper(String sql, Object[] args, RowMapper<T> rowMapper) {
        return this.getJdbcTemplate().query(sql, args, rowMapper);
    }

    public <T> List<T> queryForRowMapper(String sql, RowMapper<T> rowMapper, SqlParameterSource paramSource) {
        return this.namedJdbcTemplate.query(sql, paramSource, rowMapper);
    }

    public int queryForInt(String sql, Object[] args) {
        Integer maxValue = (Integer)this.getJdbcTemplate().queryForObject(sql, Integer.class, args);
        if (maxValue == null) {
            return 0;
        }
        return maxValue;
    }

    public long queryForLong(String sql, Object[] args) {
        Long maxValue = (Long)this.getJdbcTemplate().queryForObject(sql, Long.class, args);
        if (maxValue == null) {
            return 0L;
        }
        return maxValue;
    }

    public <E> E sqlMathQuery(String sql, Object[] args, Class<E> clazz) {
        return (E)this.jdbcTemplate.queryForObject(sql, clazz, args);
    }

    public <E> List<E> sqlListObjectWhereIn(String sql, RowMapper<E> rowMapper, SqlParameterSource paramSource) {
        return this.namedJdbcTemplate.query(sql, paramSource, rowMapper);
    }

    public <E> GenericPager<E> sqlSimpleQueryPager(String sql, Object[] args, RowMapper<E> rowMapper, String pageSql) {
        StringBuilder sqlCount = new StringBuilder();
        sqlCount.append("select count(*) cnt from (");
        sqlCount.append(sql);
        sqlCount.append(") t");
        int count = (Integer)this.jdbcTemplate.queryForObject(sqlCount.toString(), Integer.class, args);
        int pageIndex = ListPageContext.getCurrentPageIndex();
        int pageSize = ListPageContext.getCurrentPageSize();
        GenericPager pager = ListPageContext.createGenericPager((int)pageIndex, (int)pageSize, (int)count);
        List datas = this.jdbcTemplate.query(pageSql, rowMapper, this.getSqlPageArgs(args, (int)pager.getFirstRowIndexInPage(), pageSize));
        this.logger.debug(pageSql);
        return pager.setDatas(datas);
    }

    protected Object[] getSqlPageArgs(Object[] args, int firstRowIndex, int pageSize) {
        Object[] params = null;
        if (args == null || args.length == 0) {
            params = new Object[2];
        } else {
            params = new Object[args.length + 2];
            for (int j = 0; j < args.length; ++j) {
                params[j] = args[j];
            }
        }
        DatabaseType type = this.getDatabaseType();
        if (type == DatabaseType.MYSQL || type == DatabaseType.DERBY) {
            params[j] = pageSize;
            params[j + 1] = firstRowIndex;
        } else if (type == DatabaseType.ORACLE || type == DatabaseType.DAMENG) {
            params[j] = firstRowIndex + pageSize;
            params[j + 1] = firstRowIndex;
        } else if (type == DatabaseType.POSTGRES) {
            params[j] = pageSize;
            params[j + 1] = firstRowIndex;
        } else if (type == DatabaseType.SQLSERVER) {
            throw new UnsupportedOperationException("not implements setPageParameters for sqlserver.");
        }
        if (this.logger.isDebugEnabled()) {
            for (Object obj : params) {
                this.logger.debug("pager param =" + obj);
            }
        }
        return params;
    }

    public void batchUpdate(String sql) {
        this.batchUpdate(sql, null);
    }

    public void batchUpdate(String sql, final List<Object[]> parameters) {
        this.jdbcTemplate.batchUpdate(sql, new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                if (parameters == null) {
                    return;
                }
                Object[] param = (Object[])parameters.get(i);
                if (param == null || param.length == 0) {
                    return;
                }
                int _psize = param.length;
                Object _p = null;
                Class<?> _pc = null;
                for (int j = 1; j < _psize + 1; ++j) {
                    _p = param[j - 1];
                    if (_p == null) {
                        throw new IllegalArgumentException("parameter in arrays can't be null!");
                    }
                    _pc = _p.getClass();
                    if (_pc.isPrimitive()) {
                        if (_pc == Integer.TYPE) {
                            ps.setInt(j, (Integer)_p);
                            continue;
                        }
                        if (_pc == Float.TYPE) {
                            ps.setFloat(j, ((Float)_p).floatValue());
                            continue;
                        }
                        if (_pc == Boolean.TYPE) {
                            ps.setBoolean(j, (Boolean)_p);
                            continue;
                        }
                        if (_pc == Long.TYPE) {
                            ps.setLong(j, (Long)_p);
                            continue;
                        }
                        if (_pc != Double.TYPE) continue;
                        ps.setDouble(j, (Double)_p);
                        continue;
                    }
                    if (_pc == String.class) {
                        ps.setString(j, _p.toString());
                        continue;
                    }
                    if (_pc == Integer.class) {
                        ps.setInt(j, (Integer)_p);
                        continue;
                    }
                    if (_pc == Float.class) {
                        ps.setFloat(j, ((Float)_p).floatValue());
                        continue;
                    }
                    if (_pc == Boolean.class) {
                        ps.setBoolean(j, (Boolean)_p);
                        continue;
                    }
                    if (_pc == Long.class) {
                        ps.setLong(j, (Long)_p);
                        continue;
                    }
                    if (_pc == Double.class) {
                        ps.setDouble(j, (Double)_p);
                        continue;
                    }
                    ps.setObject(j, _p);
                }
            }

            public int getBatchSize() {
                if (parameters == null) {
                    return 0;
                }
                return parameters.size();
            }
        });
    }

    @Override
    public Object invoke(Object ... param) throws Exception {
        int s = param.length;
        if (s < 2) {
            throw new IllegalArgumentException("\u6570\u636e\u5e93\u67e5\u8be2\u53c2\u6570\u7f3a\u5931\uff0c\u81f3\u5c112\u4e2a\uff1asql, args, rowMapper(option)");
        }
        if (s == 3) {
            return this.jdbcTemplate.query((String)param[0], (RowMapper)param[2], (Object[])param[1]);
        }
        return this.jdbcTemplate.queryForList((String)param[0], (Object[])param[1]);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.manageMode && StringUtils.isEmpty((String)this.getServiceName())) {
            throw new IllegalArgumentException("\u672a\u63d0\u4f9b\u6570\u636e\u5e93\u540d\u79f0\uff1aserviceName");
        }
        Map<String, String> params = this.getParameters();
        if (params.size() <= 0) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u6570\u636e\u5e93\u8fde\u63a5\u53c2\u6570");
        }
        if (params.get(OPTION_USER) == null || params.get(OPTION_PASSWORD) == null) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u6570\u636e\u5e93\u8fde\u63a5\u53c2\u6570:\u7528\u6237\u540d\u6216\u5bc6\u7801");
        }
        MyDruidDataSource ds = this.acquireDruidDataSource(params);
        this.jdbcTemplate = new JdbcTemplate((DataSource)ds);
        this.namedJdbcTemplate = new NamedParameterJdbcTemplate((DataSource)ds);
        this.dataSource = ds;
    }

    private MyDruidDataSource acquireDruidDataSource(Map<String, String> params) {
        MyDruidDataSource druidDataSource = new MyDruidDataSource();
        druidDataSource.setIp(this.getUrl());
        druidDataSource.setPort(this.getPort());
        druidDataSource.setDatabaseType(this.getDatabaseType().getTypeIndex());
        druidDataSource.setDatabaseName(this.getServiceName());
        druidDataSource.setUsername(params.get(OPTION_USER));
        druidDataSource.setPassword(params.get(OPTION_PASSWORD));
        if (params.get(OPTION_MAX_ACTIVE) != null) {
            druidDataSource.setMaxActive(Integer.parseInt(params.get(OPTION_MAX_ACTIVE)));
        } else {
            druidDataSource.setMaxActive(20);
        }
        if (params.get(OPTION_INIT_SIZE) != null) {
            druidDataSource.setInitialSize(Integer.parseInt(params.get(OPTION_INIT_SIZE)));
        } else {
            druidDataSource.setInitialSize(5);
        }
        druidDataSource.setMinIdle(10);
        druidDataSource.setMaxWait(60000L);
        druidDataSource.setTimeBetweenEvictionRunsMillis(60000L);
        druidDataSource.setMinEvictableIdleTimeMillis(30000L);
        druidDataSource.setMaxEvictableIdleTimeMillis(180000L);
        druidDataSource.setValidationQuery("select 1");
        druidDataSource.setTestWhileIdle(true);
        druidDataSource.setTestOnBorrow(false);
        druidDataSource.setTestOnReturn(false);
        druidDataSource.setMaxOpenPreparedStatements(64);
        return druidDataSource;
    }

    @Override
    public void destroy() {
    }

    protected abstract DatabaseType getDatabaseType();
}

