/*
 * Decompiled with CFR 0.152.
 */
package com.walker.connector.support;

import com.walker.api.client.JsonTransfer;
import com.walker.api.client.MapTransfer;
import com.walker.api.client.RequestData;
import com.walker.api.client.ResponseData;
import com.walker.connector.AbstractConnector;
import com.walker.remote.AbstractByteCoder;
import com.walker.remote.DoubleTrust;
import com.walker.remote.RemoteAccessor;
import com.walker.remote.util.HttpUtils;
import java.util.Map;
import org.apache.hc.client5.http.cookie.CookieStore;

public class HttpConnector
extends AbstractConnector {
    private RemoteAccessor remoteAccessor = null;
    private DoubleTrust clientTrust;

    public DoubleTrust getClientTrust() {
        return this.clientTrust;
    }

    public void setClientTrust(DoubleTrust clientTrust) {
        this.clientTrust = clientTrust;
    }

    @Override
    public Object invoke(Object ... param) throws Exception {
        if (param.length < 2) {
            throw new IllegalArgumentException("http\u8c03\u7528\u53c2\u6570\u7f3a\u5931\uff0c\u81f3\u5c112\u4e2a\uff1arequest, responseData");
        }
        if (param.length == 3) {
            this.requestRemoteTextWithCookie(this.remoteAccessor, (RequestData)param[0], (ResponseData)param[1], (CookieStore)param[2]);
        } else {
            this.requestRemoteText(this.remoteAccessor, (RequestData)param[0], (ResponseData)param[1]);
        }
        return null;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.remoteAccessor == null) {
            this.remoteAccessor = this.getNewRemoteAccessor(this.getUrl());
        }
    }

    @Override
    public void destroy() {
        if (this.remoteAccessor != null) {
            this.remoteAccessor = null;
        }
    }

    protected RemoteAccessor getNewRemoteAccessor(String remoteURL, AbstractByteCoder contentCoder) {
        return HttpUtils.getInstance().getNewRemoteAccessor(remoteURL, contentCoder, this.clientTrust);
    }

    protected RemoteAccessor getNewRemoteAccessor(String remoteURL) {
        return HttpUtils.getInstance().getNewRemoteAccessor(remoteURL, null, this.clientTrust);
    }

    public <T> void requestRemoteText(RemoteAccessor remoteAccessor, RequestData request, ResponseData<T> responseData) {
        if (request == null) {
            throw new IllegalArgumentException();
        }
        Class requestDataClazz = request.getClass();
        if (MapTransfer.class.isAssignableFrom(requestDataClazz)) {
            MapTransfer mapTransfer = (MapTransfer)request;
            this.doRequestRemoteText(remoteAccessor, request.getRequestMethod(), mapTransfer.toMap(), null, responseData);
        } else if (JsonTransfer.class.isAssignableFrom(requestDataClazz)) {
            JsonTransfer jsonTransfer = (JsonTransfer)request;
            this.doRequestRemoteText(remoteAccessor, request.getRequestMethod(), null, jsonTransfer.toJsonString(), responseData);
        }
    }

    private <T> void doRequestRemoteText(RemoteAccessor remoteAccessor, String methodName, Map<String, String> simpleData, String jsonParameter, ResponseData<T> responseData) {
        if (remoteAccessor == null) {
            throw new IllegalStateException("remoteAccessor is required. \u8bf7\u5148\u8c03\u7528initialize()\u65b9\u6cd5");
        }
        remoteAccessor.requestTextSync(methodName, simpleData, jsonParameter, responseData);
    }

    public <T> void requestRemoteTextWithCookie(RemoteAccessor remoteAccessor, RequestData request, ResponseData<T> responseData, CookieStore cookieStore) {
        if (request == null) {
            throw new IllegalArgumentException();
        }
        Class requestDataClazz = request.getClass();
        if (MapTransfer.class.isAssignableFrom(requestDataClazz)) {
            MapTransfer mapTransfer = (MapTransfer)request;
            this.doRequestRemoteTextWithCookie(remoteAccessor, request.getRequestMethod(), mapTransfer.toMap(), null, responseData, cookieStore);
        } else if (JsonTransfer.class.isAssignableFrom(requestDataClazz)) {
            JsonTransfer jsonTransfer = (JsonTransfer)request;
            this.doRequestRemoteTextWithCookie(remoteAccessor, request.getRequestMethod(), null, jsonTransfer.toJsonString(), responseData, cookieStore);
        }
    }

    private <T> void doRequestRemoteTextWithCookie(RemoteAccessor remoteAccessor, String methodName, Map<String, String> simpleData, String jsonParameter, ResponseData<T> responseData, CookieStore cookieStore) {
        if (remoteAccessor == null) {
            throw new IllegalStateException("remoteAccessor is required. \u8bf7\u5148\u8c03\u7528initialize()\u65b9\u6cd5");
        }
        remoteAccessor.requestTextSyncWithCookie(methodName, simpleData, jsonParameter, responseData, cookieStore);
    }

    public <T> void requestGet(String methodName, Map<String, String> simpleData, Map<String, String> header, ResponseData<T> responseData) {
        this.checkRemoteAccessor();
        this.remoteAccessor.requestSync(methodName, simpleData, null, "GET", "application/json;charset=UTF-8", header, responseData);
    }

    public <T> void requestPost(String methodName, String jsonParameter, Map<String, String> header, ResponseData<T> responseData) {
        this.checkRemoteAccessor();
        this.remoteAccessor.requestSyncPost(methodName, jsonParameter, header, responseData);
    }

    public <T> void requestPut(String methodName, String jsonParameter, Map<String, String> header, ResponseData<T> responseData) {
        this.checkRemoteAccessor();
        this.remoteAccessor.requestSyncPut(methodName, jsonParameter, header, responseData);
    }

    public <T> void requestDelete(String methodName, String jsonParameter, Map<String, String> header, ResponseData<T> responseData) {
        this.checkRemoteAccessor();
        this.remoteAccessor.requestSyncDelete(methodName, jsonParameter, header, responseData);
    }

    private void checkRemoteAccessor() {
        if (this.remoteAccessor == null) {
            throw new IllegalStateException("remoteAccessor is required. \u8bf7\u5148\u8c03\u7528initialize()\u65b9\u6cd5");
        }
    }

    public static void main(String[] args) {
        HttpConnector connector = new HttpConnector();
        connector.setUrl("http://193.193.193.28:9200");
        connector.initialize();
    }
}

