/*
 * Decompiled with CFR 0.152.
 */
package com.walker.connector.util;

import com.walker.connector.Address;
import com.walker.connector.db.DamengConnector;
import com.walker.connector.db.MySqlConnector;
import com.walker.connector.db.OracleConnector;
import com.walker.connector.db.PostgresConnector;
import com.walker.connector.support.DatabaseConnector;
import com.walker.db.DatabaseType;
import com.walker.infrastructure.utils.StringUtils;
import java.util.HashMap;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.TransactionProxyFactoryBean;

public abstract class ConnectorUtils {
    public static final DatabaseConnector acquireTransactionProxyConnector(DatabaseConnector connector) {
        DataSourceTransactionManager transactionManager = new DataSourceTransactionManager(connector.getDataSource());
        Properties transactionAttributes = new Properties();
        transactionAttributes.put("query*", "PROPAGATION_SUPPORTS,readOnly");
        transactionAttributes.put("exec*", "PROPAGATION_REQUIRED, -Exception");
        TransactionProxyFactoryBean transactionProxy = new TransactionProxyFactoryBean();
        transactionProxy.setTransactionManager((PlatformTransactionManager)transactionManager);
        transactionProxy.setTransactionAttributes(transactionAttributes);
        transactionProxy.setProxyTargetClass(true);
        transactionProxy.setTarget((Object)connector);
        transactionProxy.afterPropertiesSet();
        return (DatabaseConnector)transactionProxy.getObject();
    }

    public static final DatabaseConnector createMySQLConnector(DataSource ds) {
        return ConnectorUtils.doCreateMySqLConnector(null, false, ds);
    }

    public static final DatabaseConnector createMySQLConnector(Address address) {
        return ConnectorUtils.doCreateMySqLConnector(address, false, null);
    }

    public static final DatabaseConnector createMySQLManageConnector(Address address) {
        return ConnectorUtils.doCreateMySqLConnector(address, true, null);
    }

    private static DatabaseConnector doCreateMySqLConnector(Address address, boolean manageMode, DataSource ds) {
        if (ds != null) {
            MySqlConnector dbConnector = new MySqlConnector(ds);
            return dbConnector;
        }
        MySqlConnector dbConnector = new MySqlConnector();
        dbConnector.setUrl(address.getUrl());
        dbConnector.setPort(address.getPort());
        if (manageMode) {
            dbConnector.setManageMode();
        } else {
            if (StringUtils.isEmpty((String)address.getServiceName())) {
                throw new IllegalArgumentException("\u672a\u8bbe\u7f6e\u8fde\u63a5\u6570\u636e\u5e93\u540d\u79f0\uff1aaddress.service = null.");
            }
            dbConnector.setServiceName(address.getServiceName() + "?characterEncoding=UTF-8");
        }
        HashMap<String, String> parameters = new HashMap<String, String>(5);
        parameters.put("user", address.getAuthentication());
        parameters.put("password", address.getCertification());
        if (address.getMaxActive() > 0) {
            parameters.put("maxActive", String.valueOf(address.getMaxActive()));
        } else {
            parameters.put("maxActive", "6");
        }
        if (address.getMaxIdle() > 0) {
            parameters.put("maxIdle", String.valueOf(address.getMaxIdle()));
        } else {
            parameters.put("maxIdle", "6");
        }
        if (address.getInitSize() > 0) {
            parameters.put("initialSize", String.valueOf(address.getInitSize()));
        } else {
            parameters.put("initialSize", "3");
        }
        dbConnector.setParameters(parameters);
        dbConnector.initialize();
        return dbConnector;
    }

    public static final DatabaseConnector createOracleConnector(DataSource ds) {
        return ConnectorUtils.doCreateOracleConnector(null, false, ds);
    }

    public static final DatabaseConnector createOracleConnector(Address address) {
        return ConnectorUtils.doCreateOracleConnector(address, false, null);
    }

    public static final DatabaseConnector createOracleManageConnector(Address address) {
        return ConnectorUtils.doCreateOracleConnector(address, true, null);
    }

    public static final DatabaseConnector createDamengConnector(Address address) {
        return ConnectorUtils.doCreateDamengConnector(address, false, null);
    }

    public static final DatabaseConnector createDamengManageConnector(Address address) {
        return ConnectorUtils.doCreateDamengConnector(address, true, null);
    }

    private static DatabaseConnector doCreateDamengConnector(Address address, boolean manageMode, DataSource ds) {
        if (ds != null) {
            DamengConnector dbConnector = new DamengConnector(ds);
            return dbConnector;
        }
        DamengConnector dbConnector = new DamengConnector();
        dbConnector.setUrl(address.getUrl());
        dbConnector.setPort(address.getPort());
        if (manageMode) {
            dbConnector.setManageMode();
        } else {
            if (StringUtils.isEmpty((String)address.getServiceName())) {
                throw new IllegalArgumentException("\u672a\u8bbe\u7f6e\u8fde\u63a5\u6570\u636e\u5e93\u540d\u79f0\uff1aaddress.service = null.");
            }
            dbConnector.setServiceName(address.getServiceName());
        }
        HashMap<String, String> parameters = new HashMap<String, String>(5);
        parameters.put("user", address.getAuthentication());
        parameters.put("password", address.getCertification());
        parameters.put("maxActive", "6");
        parameters.put("maxIdle", "3");
        parameters.put("initialSize", "3");
        dbConnector.setParameters(parameters);
        dbConnector.initialize();
        return dbConnector;
    }

    private static DatabaseConnector doCreateOracleConnector(Address address, boolean manageMode, DataSource ds) {
        if (ds != null) {
            OracleConnector dbConnector = new OracleConnector(ds);
            return dbConnector;
        }
        OracleConnector dbConnector = new OracleConnector();
        dbConnector.setUrl(address.getUrl());
        dbConnector.setPort(address.getPort());
        if (manageMode) {
            dbConnector.setManageMode();
        } else {
            if (StringUtils.isEmpty((String)address.getServiceName())) {
                throw new IllegalArgumentException("\u672a\u8bbe\u7f6e\u8fde\u63a5\u6570\u636e\u5e93\u540d\u79f0\uff1aaddress.service = null.");
            }
            dbConnector.setServiceName(address.getServiceName());
        }
        HashMap<String, String> parameters = new HashMap<String, String>(5);
        parameters.put("user", address.getAuthentication());
        parameters.put("password", address.getCertification());
        parameters.put("maxActive", "6");
        parameters.put("maxIdle", "3");
        parameters.put("initialSize", "3");
        dbConnector.setParameters(parameters);
        dbConnector.initialize();
        return dbConnector;
    }

    public static final DatabaseConnector createPostgresConnector(Address address) {
        return ConnectorUtils.doCreatePostgresConnector(address, false);
    }

    public static final DatabaseConnector createPostgresManageConnector(Address address) {
        return ConnectorUtils.doCreatePostgresConnector(address, true);
    }

    private static DatabaseConnector doCreatePostgresConnector(Address address, boolean manageMode) {
        PostgresConnector dbConnector = new PostgresConnector();
        dbConnector.setUrl(address.getUrl());
        dbConnector.setPort(address.getPort());
        if (manageMode) {
            dbConnector.setManageMode();
        } else {
            if (StringUtils.isEmpty((String)address.getServiceName())) {
                throw new IllegalArgumentException("\u672a\u8bbe\u7f6e\u8fde\u63a5\u6570\u636e\u5e93\u540d\u79f0\uff1aaddress.service = null.");
            }
            dbConnector.setServiceName(address.getServiceName());
        }
        HashMap<String, String> parameters = new HashMap<String, String>(5);
        parameters.put("user", address.getAuthentication());
        parameters.put("password", address.getCertification());
        parameters.put("maxActive", "20");
        parameters.put("initialSize", "3");
        dbConnector.setParameters(parameters);
        dbConnector.initialize();
        return dbConnector;
    }

    public static final DatabaseConnector getDbConnectorByType(Address addr, boolean manage, DatabaseType databaseType) {
        if (databaseType == DatabaseType.MYSQL) {
            if (manage) {
                return ConnectorUtils.createMySQLManageConnector(addr);
            }
            return ConnectorUtils.createMySQLConnector(addr);
        }
        if (databaseType == DatabaseType.POSTGRES) {
            if (manage) {
                return ConnectorUtils.createPostgresManageConnector(addr);
            }
            return ConnectorUtils.createPostgresConnector(addr);
        }
        if (databaseType == DatabaseType.ORACLE) {
            if (manage) {
                return ConnectorUtils.createOracleManageConnector(addr);
            }
            return ConnectorUtils.createOracleConnector(addr);
        }
        if (databaseType == DatabaseType.DAMENG) {
            if (manage) {
                return ConnectorUtils.createDamengManageConnector(addr);
            }
            return ConnectorUtils.createDamengConnector(addr);
        }
        throw new UnsupportedOperationException("\u672a\u5b9e\u73b0\u5bf9\u5176\u4ed6\u6570\u636e\u5e93\u7684\u652f\u6301\uff1aDatabaseConnector");
    }
}

