package com.walker.connector;

import com.walker.infrastructure.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.Map;

public abstract class AbstractConnector implements Connector {

	protected transient final Logger logger = LoggerFactory.getLogger(getClass());
	
	private String url;
	private int port = 0;
	private String serviceName;
	private Map<String, String> parameters = new HashMap<String, String>(2);
	
	public void setUrl(String url) {
		this.url = url;
	}

	public void setPort(int port) {
		this.port = port;
	}

	public void setServiceName(String serviceName) {
		this.serviceName = serviceName;
	}

	public void setParameters(Map<String, String> parameters) {
		this.parameters = parameters;
	}

	@Override
	public String getUrl() {
		return url;
	}

	@Override
	public int getPort() {
		return port;
	}

	@Override
	public String getServiceName() {
		return this.serviceName;
	}

	@Override
	public Map<String, String> getParameters() {
		return this.parameters;
	}

//	@Override
//	public Object invoke() throws Exception {
//		return null;
//	}
//	@Override
//	public void destroy() {
//
//	}

	@Override
	public void initialize() {
		if(StringUtils.isEmpty(url)){
			throw new IllegalStateException("url必须设置");
		}
	}

}
