package com.walker.connector;

import java.util.Map;

/**
 * 连接器定义，目前主要实现数据库连接器与http连接器。
 * @author 时克英
 * @date 2017-07-09
 */
public interface Connector {

	String getUrl();
	
	int getPort();
	
	/**
	 * 返回库或者服务名字
	 * @return
	 */
	String getServiceName();
	
//	Map<String, String> parameters = new HashMap<String, String>(2);
	Map<String, String> getParameters();
	
	Object invoke(Object... param) throws Exception;
	
	void initialize();
	
	void destroy();
}
