package com.walker.connector;

import com.walker.jdbc.DataSourceMeta;

/**
 * 本地（主要）数据库地址信息对象。
 * 在采集模块中，通过该对象可以直接连接自己数据库。
 * @date 2022-09-13
 * @author 时克英
 */
public class LocalAddress extends Address {

    public LocalAddress(DataSourceMeta dataSourceMeta){
        if(dataSourceMeta == null){
            throw new IllegalArgumentException("DataSourceMeta 必须提供!");
        }
//        String jdbcUrl = dataSourceMeta.getUrl();
        this.setUrl(dataSourceMeta.getIp());
        this.setPort(dataSourceMeta.getPort());
        this.setService(dataSourceMeta.getDatabaseName());
        this.setAuthentication(dataSourceMeta.getUsername());
        this.setCertification(dataSourceMeta.getPassword());
        this.setUsing(true);
    }

}
