package com.walker.dbmeta;

import java.io.Serializable;

/**
 * 描述：数据表列信息定义
 * @author 时克英
 * @date 2017年12月13日 下午2:32:49
 */

public class FieldInfo implements Serializable {

	/**
	 *
	 */
	private static final long serialVersionUID = -6995611895441412428L;

	public static final String TYPE_LONG = "long";
	public static final String TYPE_DOUBLE = "double";
	public static final String TYPE_STRING = "string";
	public static final String TYPE_TIMESTAMP = "timestamp";

	/**
	 * 主键值定义。
	 * @date 2023-03-03
	 */
	public static final String NAME_PRIMARY_KEY = "PRI";

	private String fieldName;
	private String tableName;
	private String dataType;
	private String comments;
	private int columnId = 0;
	private String nullable = "Y";
	private long length = 0;

	// 对于数值，存在精度、小数属性
	private int precision = 10;
	private int scale = 0;

	// 某个列是否索引列（Mysql提供，但oracle还未知）
	private String columnKey;
	private String summary;

	public String getColumnKey() {
		return columnKey;
	}
	public void setColumnKey(String columnKey) {
		this.columnKey = columnKey;
	}
	public String getSummary() {
		return summary;
	}
	public void setSummary(String summary) {
		this.summary = summary;
	}
	public int getPrecision() {
		return precision;
	}
	public void setPrecision(int precision) {
		this.precision = precision;
	}
	public int getScale() {
		return scale;
	}
	public void setScale(int scale) {
		this.scale = scale;
	}
	public String getFieldName() {
		return fieldName;
	}
	public void setFieldName(String fieldName) {
		this.fieldName = fieldName;
	}
	public String getTableName() {
		return tableName;
	}
	public void setTableName(String tableName) {
		this.tableName = tableName;
	}
	public String getDataType() {
		return dataType;
	}
	public void setDataType(String dataType) {
		this.dataType = dataType;
	}
	public String getComments() {
		return comments;
	}
	public void setComments(String comments) {
		this.comments = comments;
	}
	public int getColumnId() {
		return columnId;
	}
	public void setColumnId(int columnId) {
		this.columnId = columnId;
	}
	public String getNullable() {
		return nullable;
	}
	public void setNullable(String nullable) {
		this.nullable = nullable;
	}
	public long getLength() {
		return length;
	}
	public void setLength(long length) {
		this.length = length;
	}

	@Override
	public String toString(){
		return new StringBuilder("[columnId=").append(this.columnId)
				.append(", fieldName=").append(this.fieldName)
				.append(", dataType=").append(this.dataType)
				.append(", comments=").append(this.comments)
				.append(", precision=").append(this.precision)
				.append(", scale=").append(this.scale)
				.append(", summary=").append(this.summary)
				.append("]").toString();
	}
}
