package com.walker.dbmeta.support;

import com.walker.connector.Address;
import com.walker.connector.support.DatabaseConnector;
import com.walker.connector.util.ConnectorUtils;

/**
 * 达梦数据库元数据引擎实现，目前和<code>Oracle</code>保持一致。
 * @author 时克英
 * @date 2023-03-03
 */
public class DamengMetaEngine extends OracleMetaEngine{

    @Override
    protected DatabaseConnector createDbConnector(Address address) {
        DatabaseConnector connector = ConnectorUtils.createDamengConnector(address);
        if(connector == null){
            throw new IllegalArgumentException("connector create failed!");
        }
        return ConnectorUtils.acquireTransactionProxyConnector(connector);
    }
}
