/*
 * Decompiled with CFR 0.152.
 */
package com.walker.dbmeta;

import com.walker.connector.Address;
import com.walker.connector.support.DatabaseConnector;
import com.walker.db.DatabaseException;
import com.walker.db.TableInfo;
import com.walker.dbmeta.DatabaseMetaEngine;
import com.walker.dbmeta.FieldInfo;
import com.walker.dbmeta.util.DatabaseMetaEngineUtils;
import com.walker.infrastructure.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDatabaseMetaEngine
implements DatabaseMetaEngine {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private DatabaseConnector connector = null;

    @Override
    public List<FieldInfo> getFieldsObject(Address address, String tableName) {
        DatabaseConnector conn = this.getConnector(address);
        this.checkSchema(address.getServiceName());
        return this.loadFieldsObject(conn, tableName);
    }

    protected abstract List<FieldInfo> loadFieldsObject(DatabaseConnector var1, String var2);

    @Override
    public List<String> getFields(Address address, String tableName) {
        DatabaseConnector conn = this.getConnector(address);
        this.checkSchema(address.getServiceName());
        return this.loadFields(conn, tableName);
    }

    @Override
    public int getTableSize(Address address) {
        DatabaseConnector conn = this.getConnector(address);
        this.checkSchema(address.getServiceName());
        return this.loadSchemaTableSize(conn);
    }

    @Override
    public Map<String, TableInfo> getTableRows(Address address, List<String> tableNameList) {
        DatabaseConnector conn = this.getConnector(address);
        this.checkSchema(address.getServiceName());
        return this.loadTablesRow(address, conn, tableNameList);
    }

    @Override
    public long getTableRow(Address address, String tableName) {
        DatabaseConnector conn = this.getConnector(address);
        this.checkSchema(address.getServiceName());
        return this.loadTableRow(conn, tableName);
    }

    @Override
    public List<Map<String, Object>> loadTableDatas(Address address, String tableName, String sql) {
        DatabaseConnector conn = this.getConnector(address);
        this.checkSchema(address.getServiceName());
        try {
            return this.loadDatas(conn, tableName, sql);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected DatabaseConnector getConnector(Address address) {
        if (this.connector == null) {
            this.connector = this.createDbConnector(address);
            if (this.connector == null) {
                throw new UnsupportedOperationException("\u8bf7\u5b9e\u73b0\u65b9\u6cd5'createDbConnector()'!");
            }
        }
        return this.connector;
    }

    private void checkSchema(String schema) {
        if (schema == null) {
            throw new IllegalStateException("\u6570\u636e\u5e93\u540d\u5b57\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u6267\u884c\u5143\u6570\u636e\u67e5\u8be2");
        }
    }

    @Override
    public void initialize() {
    }

    @Override
    public void destroy() {
        if (this.connector != null) {
            this.connector.destroy();
        }
    }

    protected abstract DatabaseConnector createDbConnector(Address var1);

    protected abstract int loadSchemaTableSize(DatabaseConnector var1);

    protected abstract List<String> loadFields(DatabaseConnector var1, String var2);

    protected abstract Map<String, TableInfo> loadTablesRow(Address var1, DatabaseConnector var2, List<String> var3);

    protected abstract long loadTableRow(DatabaseConnector var1, String var2);

    protected abstract List<Map<String, Object>> loadDatas(DatabaseConnector var1, String var2, String var3) throws Exception;

    @Override
    public List<String> getTableNamesByLike(Address address, String tableNameLike) {
        return null;
    }

    @Override
    public void createTableDynamic(Address address, List<Map<String, Object>> datas, String dataVersionField, String tableName) throws DatabaseException {
        if (StringUtils.isEmptyList(datas)) {
            this.logger.warn("\u672a\u627e\u5230\u4efb\u4f55\u6570\u636e\u96c6\u5408\uff0c\u65e0\u6cd5\u52a8\u6001\u521b\u5efa\u8868\u7ed3\u6784\u3002tableName = " + tableName);
            return;
        }
        if (StringUtils.isEmpty((String)tableName)) {
            throw new DatabaseException("\u672a\u63d0\u4f9b\u8868\u540d\uff0c\u65e0\u6cd5\u52a8\u6001\u521b\u5efa\u8868\u7ed3\u6784");
        }
        tableName = tableName.toLowerCase();
        List<FieldInfo> fieldList = this.doAquireFieldList(datas.get(0), tableName);
        if (StringUtils.isEmptyList(fieldList)) {
            this.logger.warn("this.doAquireFieldList()\u8fd4\u56de\u7684\u5b57\u6bb5\u96c6\u5408\u4e3a\u7a7a\uff0c\u4e0d\u521b\u5efa\u8868");
            return;
        }
        if (StringUtils.isNotEmpty((String)dataVersionField)) {
            if (!DatabaseMetaEngineUtils.isNumberField(fieldList, dataVersionField)) {
                throw new DatabaseException("\u6570\u636e\u7248\u672c\u5b57\u6bb5\u5fc5\u987b\u662flong\u7c7b\u578b\uff1a" + dataVersionField);
            }
        } else {
            this.logger.info("dataVersionField\u5b57\u6bb5\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u589e\u91cf\u91c7\u96c6\uff0c\u53ea\u80fd\u5168\u91cf\u66f4\u65b0\u3002table = " + tableName);
        }
        this.doCreateTableAction(address, fieldList, dataVersionField, tableName);
    }

    private List<FieldInfo> doAquireFieldList(Map<String, Object> data, String tableName) throws DatabaseException {
        if (data.size() == 0) {
            return null;
        }
        ArrayList<FieldInfo> fieldList = new ArrayList<FieldInfo>();
        FieldInfo fi = null;
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            fi = DatabaseMetaEngineUtils.getFieldInfo(entry.getKey(), entry.getValue(), tableName);
            if (fi == null) {
                throw new DatabaseException("fieldInfo\u5bf9\u8c61\u521b\u5efa\u5931\u8d25\uff1a" + entry.getKey() + ", table = " + tableName);
            }
            fieldList.add(fi);
        }
        return fieldList;
    }

    protected abstract void doCreateTableAction(Address var1, List<FieldInfo> var2, String var3, String var4) throws DatabaseException;

    @Override
    public DatabaseConnector getConnector() {
        return this.connector;
    }

    @Override
    public void setConnector(DatabaseConnector connector) {
        if (this.connector != null) {
            throw new IllegalStateException("this.connector\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u8bbe\u7f6e");
        }
        this.connector = connector;
    }
}

