/*
 * Decompiled with CFR 0.152.
 */
package com.walker.dbmeta.support;

import com.walker.connector.Address;
import com.walker.connector.support.DatabaseConnector;
import com.walker.connector.util.ConnectorUtils;
import com.walker.db.DatabaseException;
import com.walker.db.TableInfo;
import com.walker.db.page.GenericPager;
import com.walker.dbmeta.AbstractDatabaseMetaEngine;
import com.walker.dbmeta.FieldInfo;
import com.walker.dbmeta.util.DatabaseMetaEngineUtils;
import com.walker.dbmeta.util.DatabaseUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.jdbc.util.StringSqlUtils;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class MySQLMetaEngine
extends AbstractDatabaseMetaEngine {
    public static final String SQL_GET_TBL_COUNT = "SELECT COUNT(*) cnt FROM information_schema.`TABLES` WHERE TABLE_SCHEMA = ? AND TABLE_TYPE = 'BASE TABLE'";
    public final String QUERY_TABLE_FIELDS = "SELECT COLUMN_NAME from information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ?";
    public final String QUERY_COLUMNS_LIST = "select table_name,column_name,data_type,NUMERIC_PRECISION data_precision,NUMERIC_SCALE data_scale, column_key, column_comment from INFORMATION_SCHEMA.Columns where table_schema=(SELECT DATABASE()) and table_name like ? order by table_name,ordinal_position";
    public final String SQL_TABLES_ROW = "SELECT TABLE_NAME tname, TABLE_COMMENT summary, TABLE_ROWS trows FROM information_schema.`TABLES`  WHERE TABLE_SCHEMA = :schema AND TABLE_TYPE = 'BASE TABLE' AND TABLE_NAME in (:ids)";
    public final String SQL_ONE_TABLE_ROW = "SELECT TABLE_ROWS trows FROM information_schema.`TABLES`  WHERE TABLE_SCHEMA = ? AND TABLE_TYPE = 'BASE TABLE' AND TABLE_NAME = ?";
    public final String SQL_TABLE_LIKE = "SELECT TABLE_NAME  FROM information_schema.`TABLES`  WHERE TABLE_SCHEMA = ? AND TABLE_TYPE = 'BASE TABLE' AND TABLE_NAME like ?";
    public final String SQL_TABLE_LIKE_PAGE = "SELECT TABLE_NAME tname, TABLE_ROWS trows, TABLE_COMMENT summary, AVG_ROW_LENGTH avg_row_len, DATA_LENGTH blocks, UPDATE_TIME last_analyzed, ENGINE tablespace_name  FROM information_schema.`TABLES`  WHERE TABLE_SCHEMA = ? AND TABLE_TYPE = 'BASE TABLE' AND TABLE_NAME like ?";
    public final String SQL_TABLE_PAGE = "SELECT TABLE_NAME tname, TABLE_ROWS trows, TABLE_COMMENT summary, AVG_ROW_LENGTH avg_row_len, DATA_LENGTH blocks, UPDATE_TIME last_analyzed, ENGINE tablespace_name  FROM information_schema.`TABLES`  WHERE TABLE_SCHEMA = ? AND TABLE_TYPE = 'BASE TABLE'";
    private final TableInfoMapper tableInfoMapper = new TableInfoMapper();
    private final FieldInfoMapper fieldInfoMapper = new FieldInfoMapper();

    @Override
    protected DatabaseConnector createDbConnector(Address address) {
        DatabaseConnector connector = ConnectorUtils.createMySQLConnector((Address)address);
        if (connector == null) {
            throw new IllegalArgumentException("connector create failed!");
        }
        return ConnectorUtils.acquireTransactionProxyConnector((DatabaseConnector)connector);
    }

    @Override
    protected List<Map<String, Object>> loadDatas(DatabaseConnector connector, String tableName, String sql) throws Exception {
        List list = (List)connector.invoke(new Object[]{sql, null});
        if (list == null || list.size() == 0) {
            return null;
        }
        return list;
    }

    @Override
    protected List<String> loadFields(DatabaseConnector connector, String tableName) {
        List list = connector.queryForList("SELECT COLUMN_NAME from information_schema.COLUMNS WHERE TABLE_SCHEMA = ? AND TABLE_NAME = ?", new Object[]{StringSqlUtils.getMySQLSchemaName((String)connector.getServiceName()), tableName});
        if (!StringUtils.isEmptyList((List)list)) {
            ArrayList<String> result = new ArrayList<String>(list.size());
            for (Map map : list) {
                result.add(map.get("COLUMN_NAME").toString().toLowerCase());
            }
            return result;
        }
        return null;
    }

    @Override
    protected int loadSchemaTableSize(DatabaseConnector connector) {
        return connector.queryForInt(SQL_GET_TBL_COUNT, new Object[]{connector.getServiceName()});
    }

    @Override
    protected Map<String, TableInfo> loadTablesRow(Address address, DatabaseConnector connector, List<String> tableNameList) {
        try {
            MapSqlParameterSource nameSet = new MapSqlParameterSource();
            nameSet.addValue("schema", (Object)DatabaseUtils.getMySQLSchemaName(connector.getServiceName()));
            nameSet.addValue("ids", tableNameList);
            List list = connector.queryForRowMapper("SELECT TABLE_NAME tname, TABLE_COMMENT summary, TABLE_ROWS trows FROM information_schema.`TABLES`  WHERE TABLE_SCHEMA = :schema AND TABLE_TYPE = 'BASE TABLE' AND TABLE_NAME in (:ids)", (RowMapper)this.tableInfoMapper, (SqlParameterSource)nameSet);
            if (!StringUtils.isEmptyList((List)list)) {
                HashMap<String, TableInfo> result = new HashMap<String, TableInfo>();
                for (TableInfo ti : list) {
                    result.put(ti.getName(), ti);
                }
                return result;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected long loadTableRow(DatabaseConnector connector, String tableName) {
        return connector.queryForLong("SELECT TABLE_ROWS trows FROM information_schema.`TABLES`  WHERE TABLE_SCHEMA = ? AND TABLE_TYPE = 'BASE TABLE' AND TABLE_NAME = ?", new Object[]{DatabaseUtils.getMySQLSchemaName(connector.getServiceName()), tableName});
    }

    @Override
    public List<String> getTableNamesByLike(Address address, String tableNameLike) {
        DatabaseConnector conn = this.getConnector(address);
        List list = conn.queryForList("SELECT TABLE_NAME  FROM information_schema.`TABLES`  WHERE TABLE_SCHEMA = ? AND TABLE_TYPE = 'BASE TABLE' AND TABLE_NAME like ?", new Object[]{DatabaseUtils.getMySQLSchemaName(conn.getServiceName()), DatabaseMetaEngineUtils.getLikeConditionArg(tableNameLike)});
        ArrayList<String> result = new ArrayList<String>();
        if (list != null) {
            for (Map m : list) {
                result.add(m.get("table_name").toString());
            }
        }
        return result;
    }

    @Override
    public GenericPager<TableInfo> queryPageTableNamesByLike(Address address, String tableNameLike) {
        DatabaseConnector conn = this.getConnector(address);
        String query = null;
        String pageSql = null;
        Object[] args = null;
        if (StringUtils.isNotEmpty((String)tableNameLike)) {
            query = "SELECT TABLE_NAME tname, TABLE_ROWS trows, TABLE_COMMENT summary, AVG_ROW_LENGTH avg_row_len, DATA_LENGTH blocks, UPDATE_TIME last_analyzed, ENGINE tablespace_name  FROM information_schema.`TABLES`  WHERE TABLE_SCHEMA = ? AND TABLE_TYPE = 'BASE TABLE' AND TABLE_NAME like ?";
            pageSql = "SELECT TABLE_NAME tname, TABLE_ROWS trows, TABLE_COMMENT summary, AVG_ROW_LENGTH avg_row_len, DATA_LENGTH blocks, UPDATE_TIME last_analyzed, ENGINE tablespace_name  FROM information_schema.`TABLES`  WHERE TABLE_SCHEMA = ? AND TABLE_TYPE = 'BASE TABLE' AND TABLE_NAME like ? limit ? offset ?";
            args = new Object[]{address.getServiceName(), DatabaseMetaEngineUtils.getLikeConditionArg(tableNameLike)};
        } else {
            query = "SELECT TABLE_NAME tname, TABLE_ROWS trows, TABLE_COMMENT summary, AVG_ROW_LENGTH avg_row_len, DATA_LENGTH blocks, UPDATE_TIME last_analyzed, ENGINE tablespace_name  FROM information_schema.`TABLES`  WHERE TABLE_SCHEMA = ? AND TABLE_TYPE = 'BASE TABLE'";
            pageSql = "SELECT TABLE_NAME tname, TABLE_ROWS trows, TABLE_COMMENT summary, AVG_ROW_LENGTH avg_row_len, DATA_LENGTH blocks, UPDATE_TIME last_analyzed, ENGINE tablespace_name  FROM information_schema.`TABLES`  WHERE TABLE_SCHEMA = ? AND TABLE_TYPE = 'BASE TABLE' limit ? offset ?";
            args = new Object[]{address.getServiceName()};
        }
        return conn.sqlSimpleQueryPager(query, args, (RowMapper)this.tableInfoMapper, pageSql);
    }

    @Override
    protected List<FieldInfo> loadFieldsObject(DatabaseConnector connector, String tableName) {
        return connector.queryForRowMapper("select table_name,column_name,data_type,NUMERIC_PRECISION data_precision,NUMERIC_SCALE data_scale, column_key, column_comment from INFORMATION_SCHEMA.Columns where table_schema=(SELECT DATABASE()) and table_name like ? order by table_name,ordinal_position", new Object[]{"%" + tableName}, (RowMapper)this.fieldInfoMapper);
    }

    @Override
    protected void doCreateTableAction(Address address, List<FieldInfo> fieldList, String dataVersionField, String tableName) throws DatabaseException {
        DatabaseConnector conn = this.getConnector(address);
        if (conn == null) {
            throw new DatabaseException("\u6570\u636e\u5e93\u8fde\u63a5\u5668\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u6267\u884cddl\u3002table = " + tableName);
        }
        StringBuilder tableSql = new StringBuilder();
        tableSql.append("CREATE TABLE ").append(tableName).append("(");
        int i = 0;
        for (FieldInfo fi : fieldList) {
            tableSql.append(fi.getFieldName()).append(" ");
            if (fi.getDataType().equals("double")) {
                tableSql.append("double(10,2) not null default 0");
            } else if (fi.getDataType().equals("long")) {
                tableSql.append("bigint not null default 0");
            } else if (fi.getDataType().equals("string")) {
                tableSql.append("varchar(255)");
            } else {
                throw new UnsupportedOperationException("\u672a\u5b9e\u73b0\u5b57\u6bb5\u7c7b\u578b\uff1a" + fi.getDataType());
            }
            if (++i == fieldList.size()) {
                tableSql.append(");");
                continue;
            }
            tableSql.append(",");
        }
        conn.exeCreateTable(tableSql.toString());
        if (StringUtils.isNotEmpty((String)dataVersionField)) {
            StringBuilder dataVersionIndexSql = new StringBuilder("create index inx_");
            dataVersionIndexSql.append(tableName).append('_').append(StringUtils.generateRandomNumber((int)3));
            dataVersionIndexSql.append(" on ").append(tableName);
            dataVersionIndexSql.append("(").append(dataVersionField).append(")");
            this.logger.debug("\u6dfb\u52a0\u7d22\u5f15\uff1a" + dataVersionIndexSql);
            conn.execute(dataVersionIndexSql.toString());
        }
    }

    public static void main(String[] args) {
        Address address = new Address();
        address.setUrl("116.198.40.76");
        address.setPort(3306);
        address.setService("iplatform");
        address.setAuthentication("root");
        address.setCertification("Bjjmy_2020");
        MySQLMetaEngine metaEngine = new MySQLMetaEngine();
        try {
            List<FieldInfo> list = metaEngine.getFieldsObject(address, "s_user_core");
            if (list != null) {
                for (FieldInfo fieldInfo : list) {
                    System.out.println(fieldInfo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class TableInfoMapper
    implements RowMapper<TableInfo> {
        private TableInfoMapper() {
        }

        public TableInfo mapRow(ResultSet rs, int arg1) throws SQLException {
            ResultSetMetaData rsMetaData = rs.getMetaData();
            TableInfo ti = new TableInfo();
            ti.setName(rs.getString("tname"));
            ti.setSummary(rs.getString("summary"));
            ti.setRows((long)rs.getInt("trows"));
            if (this.containColumn("avg_row_len", rsMetaData)) {
                ti.setAvgRowLen(rs.getLong("avg_row_len"));
            }
            if (this.containColumn("blocks", rsMetaData)) {
                ti.setBlocks(rs.getLong("blocks"));
            }
            if (this.containColumn("last_analyzed", rsMetaData)) {
                ti.setLastAnalyzed(rs.getString("last_analyzed"));
            }
            if (this.containColumn("tablespace_name", rsMetaData)) {
                ti.setTableSpace(rs.getString("tablespace_name"));
            }
            ti.setStatus("");
            return ti;
        }

        private boolean containColumn(String columnName, ResultSetMetaData rsMetaData) throws SQLException {
            return DatabaseMetaEngineUtils.isContainColumnName(columnName, rsMetaData);
        }
    }

    private class FieldInfoMapper
    implements RowMapper<FieldInfo> {
        private FieldInfoMapper() {
        }

        public FieldInfo mapRow(ResultSet rs, int rowNum) throws SQLException {
            ResultSetMetaData rsMetaData = rs.getMetaData();
            FieldInfo fieldInfo = new FieldInfo();
            fieldInfo.setFieldName(rs.getString("column_name"));
            fieldInfo.setDataType(rs.getString("data_type"));
            if (DatabaseMetaEngineUtils.isContainColumnName("column_comment", rsMetaData)) {
                fieldInfo.setComments(rs.getString("column_comment"));
            }
            if (DatabaseMetaEngineUtils.isContainColumnName("data_precision", rsMetaData)) {
                fieldInfo.setPrecision(rs.getInt("data_precision"));
            }
            if (DatabaseMetaEngineUtils.isContainColumnName("data_scale", rsMetaData)) {
                fieldInfo.setScale(rs.getInt("data_scale"));
            }
            if (DatabaseMetaEngineUtils.isContainColumnName("column_key", rsMetaData)) {
                fieldInfo.setColumnKey(rs.getString("column_key"));
            }
            fieldInfo.setTableName(rs.getString("table_name"));
            return fieldInfo;
        }
    }
}

