/*
 * Decompiled with CFR 0.152.
 */
package com.walker.dbmeta.support;

import com.walker.connector.Address;
import com.walker.connector.support.DatabaseConnector;
import com.walker.connector.util.ConnectorUtils;
import com.walker.db.DatabaseException;
import com.walker.db.TableInfo;
import com.walker.db.page.GenericPager;
import com.walker.dbmeta.AbstractDatabaseMetaEngine;
import com.walker.dbmeta.FieldInfo;
import com.walker.dbmeta.util.DatabaseMetaEngineUtils;
import com.walker.dbmeta.util.DatabaseUtils;
import com.walker.infrastructure.utils.StringUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class PostgresMetaEngine
extends AbstractDatabaseMetaEngine {
    public static final String SQL_GET_TBL_COUNT = "SELECT COUNT(*) cnt FROM information_schema.TABLES WHERE table_catalog = ? and table_schema = 'public' and TABLE_TYPE = 'BASE TABLE'";
    public final String QUERY_TABLE_FIELDS = "SELECT COLUMN_NAME from information_schema.COLUMNS WHERE table_catalog = ? and table_schema = 'public' AND TABLE_NAME = ?";
    public final String SQL_TABLES_ROW = "SELECT c.relname tname, '' summary, c.reltuples trows from pg_class c, pg_namespace n  where c.relkind = 'r' and n.nspname = 'public' and c.relnamespace = n.oid and c.relname in (:ids)";
    public final String SQL_ONE_TABLE_ROW = "SELECT c.reltuples trows from pg_class c, pg_namespace n  where c.relkind = 'r' and n.nspname = 'public' and c.relnamespace = n.oid and c.relname = ?";
    public final String SQL_TABLE_LIKE = "SELECT c.relname table_name from pg_class c, pg_namespace n  where c.relkind = 'r' and n.nspname = 'public' and c.relnamespace = n.oid and c.relname like ?";
    public final String SQL_TABLE_LIKE_PAGE = "SELECT c.relname tname, '' summary, c.reltuples trows from pg_class c, pg_namespace n  where c.relkind = 'r' and n.nspname = 'public' and c.relnamespace = n.oid and c.relname like ?";
    private final TableInfoMapper tableInfoMapper = new TableInfoMapper();

    @Override
    protected DatabaseConnector createDbConnector(Address address) {
        return ConnectorUtils.createPostgresConnector((Address)address);
    }

    @Override
    protected List<Map<String, Object>> loadDatas(DatabaseConnector connector, String tableName, String sql) throws Exception {
        List list = (List)connector.invoke(new Object[]{sql, null});
        if (list == null || list.size() == 0) {
            return null;
        }
        return list;
    }

    @Override
    protected List<String> loadFields(DatabaseConnector connector, String tableName) {
        List list = connector.queryForList("SELECT COLUMN_NAME from information_schema.COLUMNS WHERE table_catalog = ? and table_schema = 'public' AND TABLE_NAME = ?", new Object[]{DatabaseUtils.getMySQLSchemaName(connector.getServiceName()), tableName});
        if (list != null && list.size() > 0) {
            ArrayList<String> result = new ArrayList<String>(list.size());
            for (Map map : list) {
                result.add(map.get("COLUMN_NAME").toString().toLowerCase());
            }
            return result;
        }
        return null;
    }

    @Override
    protected int loadSchemaTableSize(DatabaseConnector connector) {
        return connector.queryForInt(SQL_GET_TBL_COUNT, new Object[]{connector.getServiceName()});
    }

    @Override
    protected Map<String, TableInfo> loadTablesRow(Address address, DatabaseConnector connector, List<String> tableNameList) {
        try {
            MapSqlParameterSource nameSet = new MapSqlParameterSource();
            nameSet.addValue("ids", tableNameList);
            List list = connector.queryForRowMapper("SELECT c.relname tname, '' summary, c.reltuples trows from pg_class c, pg_namespace n  where c.relkind = 'r' and n.nspname = 'public' and c.relnamespace = n.oid and c.relname in (:ids)", (RowMapper)this.tableInfoMapper, (SqlParameterSource)nameSet);
            if (!StringUtils.isEmptyList((List)list)) {
                HashMap<String, TableInfo> result = new HashMap<String, TableInfo>();
                for (TableInfo ti : list) {
                    result.put(ti.getName(), ti);
                }
                return result;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected long loadTableRow(DatabaseConnector connector, String tableName) {
        return connector.queryForLong("SELECT c.reltuples trows from pg_class c, pg_namespace n  where c.relkind = 'r' and n.nspname = 'public' and c.relnamespace = n.oid and c.relname = ?", new Object[]{tableName});
    }

    @Override
    public List<String> getTableNamesByLike(Address address, String tableNameLike) {
        DatabaseConnector conn = this.getConnector(address);
        List list = conn.queryForList("SELECT c.relname table_name from pg_class c, pg_namespace n  where c.relkind = 'r' and n.nspname = 'public' and c.relnamespace = n.oid and c.relname like ?", new Object[]{DatabaseMetaEngineUtils.getLikeConditionArg(tableNameLike)});
        ArrayList<String> result = new ArrayList<String>();
        if (list != null) {
            for (Map m : list) {
                result.add(m.get("table_name").toString());
            }
        }
        return result;
    }

    @Override
    public GenericPager<TableInfo> queryPageTableNamesByLike(Address address, String tableNameLike) {
        DatabaseConnector conn = this.getConnector(address);
        String pageSql = "SELECT c.relname tname, '' summary, c.reltuples trows from pg_class c, pg_namespace n  where c.relkind = 'r' and n.nspname = 'public' and c.relnamespace = n.oid and c.relname like ? limit ? offset ?";
        Object[] args = new Object[]{tableNameLike};
        return conn.sqlSimpleQueryPager("SELECT c.relname tname, '' summary, c.reltuples trows from pg_class c, pg_namespace n  where c.relkind = 'r' and n.nspname = 'public' and c.relnamespace = n.oid and c.relname like ?", args, (RowMapper)this.tableInfoMapper, pageSql);
    }

    @Override
    protected List<FieldInfo> loadFieldsObject(DatabaseConnector connector, String tableName) {
        return null;
    }

    @Override
    protected void doCreateTableAction(Address address, List<FieldInfo> fieldList, String dataVersionField, String tableName) throws DatabaseException {
    }

    private class TableInfoMapper
    implements RowMapper<TableInfo> {
        private TableInfoMapper() {
        }

        public TableInfo mapRow(ResultSet rs, int arg1) throws SQLException {
            TableInfo ti = new TableInfo();
            ti.setName(rs.getString("tname"));
            ti.setSummary(rs.getString("summary"));
            ti.setRows((long)rs.getInt("trows"));
            return ti;
        }
    }
}

