/*
 * Decompiled with CFR 0.152.
 */
package com.walker.dbmeta.util;

import com.walker.connector.Address;
import com.walker.db.DatabaseType;
import com.walker.dbmeta.AbstractDatabaseMetaEngine;
import com.walker.dbmeta.DatabaseMetaEngine;
import com.walker.dbmeta.FieldInfo;
import com.walker.dbmeta.support.MySQLMetaEngine;
import com.walker.dbmeta.support.PostgresMetaEngine;
import com.walker.infrastructure.utils.StringUtils;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DatabaseMetaEngineUtils {
    private static final Map<Address, DatabaseMetaEngine> cached = new ConcurrentHashMap<Address, DatabaseMetaEngine>(2);

    public static final boolean isContainColumnName(String columnName, ResultSetMetaData rsMetaData) throws SQLException {
        int numberOfColumns = rsMetaData.getColumnCount();
        String column = null;
        for (int i = 1; i < numberOfColumns + 1; ++i) {
            column = rsMetaData.getColumnName(i);
            if (!column.equalsIgnoreCase(columnName)) continue;
            return true;
        }
        return false;
    }

    public static final DatabaseMetaEngine getDatabaseMetaEngine(Address address, DatabaseType databaseType) {
        if (address == null) {
            throw new IllegalArgumentException();
        }
        DatabaseMetaEngine engine = cached.get(address);
        if (engine == null) {
            engine = DatabaseMetaEngineUtils.createDatabaseMetaEngine(address, databaseType);
            cached.put(address, engine);
        }
        return engine;
    }

    private static DatabaseMetaEngine createDatabaseMetaEngine(Address address, DatabaseType databaseType) {
        AbstractDatabaseMetaEngine engine = null;
        if (databaseType == DatabaseType.MYSQL) {
            engine = new MySQLMetaEngine();
        } else if (databaseType == DatabaseType.POSTGRES) {
            engine = new PostgresMetaEngine();
        }
        engine.initialize();
        return engine;
    }

    public static final String getLikeConditionArg(String value) {
        return "%" + value + "%";
    }

    public static final FieldInfo getFieldInfo(String fieldName, Object value, String tableName) {
        FieldInfo fi = new FieldInfo();
        fi.setFieldName(fieldName.toLowerCase());
        fi.setTableName(tableName.toLowerCase());
        if (value == null) {
            fi.setDataType("string");
            return fi;
        }
        Class type = StringUtils.getNumbericType((String)value.toString());
        if (type == Long.class) {
            fi.setDataType("long");
        } else if (type == Double.class) {
            fi.setDataType("double");
        } else if (type == String.class) {
            fi.setDataType("string");
        } else {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b\uff1a" + type.getName());
        }
        return fi;
    }

    public static final boolean isNumberField(List<FieldInfo> fieldList, String dataVersionField) {
        if (StringUtils.isEmptyList(fieldList)) {
            return false;
        }
        for (FieldInfo fi : fieldList) {
            if (!fi.getFieldName().equalsIgnoreCase(dataVersionField) || !fi.getDataType().equalsIgnoreCase("long")) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        String test1 = "123test";
        String test2 = "5690.2";
        String test3 = "598000";
        String test4 = "0";
        String test5 = "";
        long startTime = System.nanoTime();
        Class clazz1 = StringUtils.getNumbericType((String)test1);
        System.out.println(test1 + " = " + clazz1.getName() + ", time = " + (System.nanoTime() - startTime));
        startTime = System.nanoTime();
        Class clazz2 = StringUtils.getNumbericType((String)test2);
        System.out.println(test2 + " = " + clazz2.getName() + ", time = " + (System.nanoTime() - startTime));
        startTime = System.nanoTime();
        Class clazz3 = StringUtils.getNumbericType((String)test3);
        System.out.println(test3 + " = " + clazz3.getSimpleName() + ", time = " + (System.nanoTime() - startTime));
        startTime = System.nanoTime();
        Class clazz4 = StringUtils.getNumbericType((String)test4);
        System.out.println(test4 + " = " + clazz4.getTypeName() + ", time = " + (System.nanoTime() - startTime));
        startTime = System.nanoTime();
        Class clazz5 = StringUtils.getNumbericType((String)test5);
        System.out.println(test5 + " = " + clazz5.getCanonicalName() + ", time = " + (System.nanoTime() - startTime));
    }
}

