/*
 * Decompiled with CFR 0.152.
 */
package com.walker.dbmeta.util;

import com.walker.connector.Address;
import com.walker.connector.support.DatabaseConnector;
import com.walker.db.DatabaseException;
import com.walker.infrastructure.utils.SegmentReader;
import com.walker.infrastructure.utils.StringUtils;

public abstract class DatabaseUtils {
    public static final String DB_SEPARATOR = "_";
    public static final String MYSQL_TBL_REF = "`";
    private static final String KEY_START = "create table ";
    private static final String KEY_START_BACK = "create table if not exists ";
    private static final String KEY_END = "(";
    private static final String KEY_START_INX = "create index ";
    private static final String KEY_END_INX = " on";
    private static final String KEY_TBL_START_INX = " on ";

    public static Address copyAddress(Address addr, boolean isUsing, int suffixIndex, String defineName) {
        Address a = new Address();
        a.setUrl(addr.getUrl());
        a.setPort(addr.getPort());
        a.setService(defineName + DB_SEPARATOR + suffixIndex);
        a.setSuffixIndex(suffixIndex);
        a.setUsing(isUsing);
        a.setAuthentication(addr.getAuthentication());
        a.setCertification(addr.getCertification());
        return a;
    }

    public static final String getMySQLSchemaName(String serviceName) {
        if (StringUtils.isEmpty((String)serviceName)) {
            return null;
        }
        int index = serviceName.indexOf("?");
        if (index >= 0) {
            return serviceName.substring(0, index);
        }
        return serviceName;
    }

    public static final int getDatabaseNameIndex(String dbName) {
        if (StringUtils.isEmpty((String)dbName)) {
            return -1;
        }
        String[] test = dbName.split(DB_SEPARATOR);
        if (test == null || test.length <= 1) {
            return -1;
        }
        String index = test[test.length - 1];
        try {
            return Integer.parseInt(index);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    public static final String findTableNameInSQL(String createTableSQL) throws DatabaseException {
        String tname;
        String _s = createTableSQL;
        if (_s.startsWith(KEY_START_BACK)) {
            String tname2 = DatabaseUtils.getSingleSqlTable(_s, KEY_START_BACK);
            if (StringUtils.isNotEmpty((String)tname2)) {
                return tname2.trim().replaceAll(MYSQL_TBL_REF, "");
            }
        } else if (_s.startsWith(KEY_START) && StringUtils.isNotEmpty((String)(tname = DatabaseUtils.getSingleSqlTable(_s, KEY_START)))) {
            return tname.trim().replaceAll(MYSQL_TBL_REF, "");
        }
        throw new DatabaseException("SQL\u4e2d\u672a\u627e\u5230\u8868\u540d" + _s);
    }

    private static String getSingleSqlTable(String sql, String keyStart) {
        SegmentReader reader = new SegmentReader();
        reader.setKeyCaseSensitive(true);
        reader.addKey(keyStart, KEY_END);
        reader.addRemoveKey("--", "\n");
        reader.read(sql);
        return reader.getSolvedContent(keyStart, KEY_END);
    }

    public static String findIndexNameInSQL(String createTableSQL) throws DatabaseException {
        String inxName;
        if (createTableSQL.startsWith(KEY_START_INX) && StringUtils.isNotEmpty((String)(inxName = DatabaseUtils.getSingleIndexName(createTableSQL)))) {
            return inxName.trim();
        }
        throw new DatabaseException("SQL\u4e2d\u672a\u627e\u5230\u7d22\u5f15\u540d\u79f0\uff0csql = " + createTableSQL);
    }

    private static String getSingleIndexName(String sql) {
        SegmentReader reader = new SegmentReader();
        reader.setKeyCaseSensitive(true);
        reader.addKey(KEY_START_INX, KEY_END_INX);
        reader.addRemoveKey("--", "\n");
        reader.read(sql);
        return reader.getSolvedContent(KEY_START_INX, KEY_END_INX);
    }

    public static final String findTableNameInIndex(String sql) {
        SegmentReader reader = new SegmentReader();
        reader.setKeyCaseSensitive(true);
        reader.addKey(KEY_TBL_START_INX, KEY_END);
        reader.addRemoveKey("--", "\n");
        reader.read(sql);
        String result = reader.getSolvedContent(KEY_TBL_START_INX, KEY_END);
        if (StringUtils.isNotEmpty((String)result)) {
            return result.trim();
        }
        return null;
    }

    public static boolean isCreateTableSQL(String sql) {
        return sql.startsWith(KEY_START_BACK) || sql.startsWith(KEY_START);
    }

    public static boolean isCreateIndexSQL(String sql) {
        return sql.startsWith(KEY_START_INX);
    }

    public static boolean manualCreatePhysicalTable(DatabaseConnector connector, String createSQL, String tableName, String business) throws DatabaseException {
        if (StringUtils.isEmpty((String)createSQL)) {
            throw new IllegalArgumentException("SQL\u8bed\u53e5\u4e2d\u672a\u627e\u5230\u8868\u540d\uff0cdestTableName = " + tableName);
        }
        String[] sqlList = createSQL.split(";");
        if (sqlList == null || sqlList.length == 0) {
            throw new DatabaseException("\u5b58\u50a8\u5f15\u64ce\u672a\u53d1\u73b0\u4efb\u4f55\u521b\u5efa\u8868\u6216\u8005\u7d22\u5f15\u7684SQL\u8bed\u53e5\uff0c\u65e0\u6cd5\u7ee7\u7eed\u6267\u884c\u5199\u5165\u6570\u636e\u4efb\u52a1\u3002createSQL = " + createSQL + ", tableName = " + tableName);
        }
        for (String sql : sqlList) {
            String indexName;
            if (DatabaseUtils.isCreateTableSQL(sql = sql.trim())) {
                String tname = DatabaseUtils.findTableNameInSQL(sql);
                if (!tname.equals(tableName)) {
                    sql = sql.replace(tname, tableName);
                }
                connector.exeCreateTable(sql);
                return true;
            }
            if (!DatabaseUtils.isCreateIndexSQL(sql)) continue;
            String iname = DatabaseUtils.findIndexNameInSQL(sql);
            if (!iname.equals(indexName = iname + DB_SEPARATOR + business)) {
                sql = sql.replace(iname, indexName);
                sql = sql.replace(DatabaseUtils.findTableNameInIndex(sql), tableName);
            }
            connector.exeCreateTable(sql);
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("1");
        System.out.println(DatabaseUtils.findTableNameInIndex("create index base_area_ver_inx_44 on base_area (ver) "));
    }
}

