package com.walker.di.excel;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.security.SystemLogMan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 默认的数据监听器实现，按照 EasyExcel 规范定义，转换成自己要的结果。<p></p>
 * 该对象一次性返回所有加载的数据。
 * @author 时克英
 * @date 2023-02-03
 */
public class DefaultDataListener extends AnalysisEventListener<Map<Integer,String>> {

    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    // 每次要保存的导入数据集合
    protected List<Object[]> rows = null;

    // 表头信息
    protected List<String> headers = null;
    private int headerSize = 0;

    // 表头行计数器
    private int currentHeadRowNumber = 1;

    public DefaultDataListener(LoadListener loadListener){
//        if(loadListener == null){
//            throw new IllegalArgumentException("LoadListener is required!");
//        }
        this.loadListener = loadListener;
        SystemLogMan.getInstance().checkMan();
    }

    @Override
    public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
//        logger.debug("处理 header----->");
//        for(Map.Entry<Integer, String> entry : headMap.entrySet()){
//            logger.debug(entry.getKey() + " = " + entry.getValue());
//        }
        if(this.currentHeadRowNumber < this.headRowNumber){
            logger.debug("表头行大于1，忽略改行，仅处理最后一行表头");
            this.currentHeadRowNumber ++;
            return;
        }
        if(this.headers == null){
            this.headers = new ArrayList<>();
            for(String head : headMap.values()){
                this.headers.add(head);
            }
            this.headerSize = this.headers.size();
        }
    }

    @Override
    public void invoke(Map<Integer, String> integerStringMap, AnalysisContext analysisContext) {
//        System.out.println("处理 data-----> " + integerStringMap);
//        for(Map.Entry<Integer, String> entry : integerStringMap.entrySet()){
//            logger.debug(entry.getKey() + " = " + entry.getValue());
//        }
//        if(this.headers == null){
//            throw new ApplicationRuntimeException("表头为空，无法继续导入数据", null);
//        }
//        if(data == null){
//            data = new ArrayList<>(256);
//        }
//        Object[] one = new Object[this.headerSize];
//        for(int i=0; i<this.headerSize; i++){
//            one[i] = integerStringMap.get(i);
//        }
//        this.data.add(one);
//        this.currentDataRowCount ++;
        this.increaseOneData(integerStringMap);

//        // 到达200条后，自动保存
//        if(this.currentDataRowCount >= this.saveSizeOnce){
//            try {
//                this.loadListener.onSave(data, this.headers);
//                this.data.clear();
//                this.data = null;
//
//            } catch (DataImportException e) {
//                throw new ApplicationRuntimeException("loadListener保存导入数据错误:" + e.getMessage(), e);
//            }
//
//            if(sleepMillSeconds > 0){
//                try {
//                    TimeUnit.MILLISECONDS.sleep(sleepMillSeconds);
//                    logger.debug("-----> sleep: " + sleepMillSeconds);
//                } catch (InterruptedException e) {
//                    logger.error("间隔等待(防止CUP过高)，出现异常:" + e.getMessage());
//                }
//            }
//        }
    }

    void increaseOneData(Map<Integer, String> integerStringMap){
        if(this.headers == null){
            throw new ApplicationRuntimeException("表头为空，无法继续导入数据", null);
        }
        if(rows == null){
            rows = new ArrayList<>(256);
        }
        Object[] one = new Object[this.headerSize];
        String value = null;
        for(int i=0; i<this.headerSize; i++){
            value = integerStringMap.get(i);
            if(StringUtils.isEmpty(value)){
                one[i] = StringUtils.EMPTY_STRING;
            } else {
                one[i] = value;
            }
        }
        this.rows.add(one);
//        this.currentDataRowCount ++;
    }

    @Override
    public void doAfterAllAnalysed(AnalysisContext analysisContext) {
        logger.info(".........导入并保存完成!");
    }

    /**
     * 返回导入的原始数据集合。
     * @return
     */
    public List<Object[]> getRows() {
        return rows;
    }

    /**
     * 返回表头行(仅标识行)
     * @return
     */
    public List<String> getHeaders() {
        return headers;
    }

    /**
     * 设置表头有几行，默认:2
     * @param headRowNumber
     */
    public void setHeadRowNumber(int headRowNumber) {
        this.headRowNumber = headRowNumber;
    }

    protected LoadListener loadListener = null;
    private int headRowNumber = 2;
}
