package com.walker.di.excel;

import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.walker.di.AbstractErrorWriter;
import com.walker.di.Constants;
import com.walker.infrastructure.utils.KeyValue;
import com.walker.infrastructure.utils.StringUtils;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

/**
 * 使用 Excel 文件实现的错误记录器。
 * @author 时克英
 * @date 2023-02-03
 */
public class ExcelErrorWriter extends AbstractErrorWriter {

    private ExcelWriter excelWriter = null;
    private WriteSheet writeSheet = null;
    private OutputStream outputStream = null;

    public ExcelErrorWriter(OutputStream outputStream, List<String> fieldNames){
        this.outputStream = outputStream;
        ExcelWriterBuilder writer = EasyExcelFactory.write(outputStream);
        writer.head(this.getHeaders(fieldNames));
//        writer.sheet(Constants.EXCEL_SHEET_NAME);
        excelWriter = writer.build();

        writeSheet = new WriteSheet();
        writeSheet.setSheetName(Constants.EXCEL_SHEET_NAME);
    }

    @Override
//    public void write(Map<String, String> data, String error) {
    public void write(List<KeyValue<String, String>> data, String error) {
        if(this.excelWriter != null){
            // 错误原因标题列和值
//            data.put(Constants.ERROR_COLUMN_NAME, error);
            data.add(new KeyValue<>(Constants.ERROR_COLUMN_NAME, error));
            List<List<String>> errorList = new ArrayList<>(2);
            List<String> one = new ArrayList<>(data.size() + 2);
//            for(Map.Entry<String, String> entry : data.entrySet()){
            for(KeyValue<String, String> kv : data){
                one.add(kv.getValue());
//                logger.debug("....." + kv.getValue());
            }
            errorList.add(one);
            excelWriter.write(errorList, writeSheet);
            logger.debug("error = " + data);
        }
    }

    @Override
    public void close() {
        if(this.excelWriter != null){
            this.excelWriter.finish();
            this.excelWriter.close();
        }
        if(this.outputStream != null){
            try {
                this.outputStream.close();
            } catch (IOException e) {}
        }
    }

    private List<List<String>> getHeaders(List<String> fieldNames){
        List<List<String>> headers = new ArrayList<>();
        for(String headerId : fieldNames){
            headers.add(StringUtils.asList(new String[]{"说明字段", headerId}));
        }
        headers.add(StringUtils.asList(new String[]{"错误原因", Constants.ERROR_COLUMN_NAME}));
        return headers;
    }
}
