package com.walker.di.excel;

import com.walker.di.BusinessImportException;
import com.walker.di.DataImportException;
import com.walker.di.ErrorWriter;

import java.util.List;

/**
 * 为了适配 <code>EasyExcel</code> 加载机制(监听通知)，所以通过该接口回调方式保存业务数据。
 * @author 时克英
 * @date 2023-02-03
 */
public interface LoadListener {

    void onSave(List<Object[]> rows, List<String> fieldNames) throws BusinessImportException;

    /**
     * 设置错误记录器，便于在业务写入失败时，能及时关闭记录器保留已经写入的结果。
     * @param errorWriter
     * @date 2023-02-06
     */
    void setErrorWriter(ErrorWriter errorWriter);

    ErrorWriter getErrorWriter();
}
