package com.walker.di.univocity;

import com.univocity.parsers.common.processor.ObjectRowWriterProcessor;
import com.univocity.parsers.csv.CsvWriter;
import com.univocity.parsers.csv.CsvWriterSettings;
import com.walker.di.AbstractErrorWriter;
import com.walker.di.Constants;
import com.walker.infrastructure.utils.KeyValue;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

/**
 * CSV方式实现的错误记录器。
 * @author 时克英
 * @date 2023-02-02
 */
public class CsvErrorWriter extends AbstractErrorWriter {

    private CsvWriter writer = null;
    private OutputStream outputStream = null;

    public CsvErrorWriter(OutputStream outputStream, List<String> fieldNames){
        this.outputStream = outputStream;
        // 加入最后一列: 错误原因
        String[] columns = this.cloneColumns(fieldNames);
        final CsvWriterSettings csvWriterSettings = new CsvWriterSettings();
        csvWriterSettings.setHeaderWritingEnabled(Boolean.TRUE);
        csvWriterSettings.setRowWriterProcessor(new ObjectRowWriterProcessor());
        csvWriterSettings.setHeaders(columns);
        writer = new CsvWriter(outputStream, csvWriterSettings);
    }

    @Override
//    public void write(Map<String, String> data, String error) {
    public void write(List<KeyValue<String, String>> data, String error) {
        if(writer != null){
//            data.put(Constants.ERROR_COLUMN_NAME, error);
            data.add(new KeyValue<>(Constants.ERROR_COLUMN_NAME, error));

//            // 数据转 Map
//            Map<String, String> map = new HashMap<>();
//            for(KeyValue<String, String> kv : data){
//                map.put(kv.getKey(), kv.getValue());
//            }
//            this.writer.processRecord(data);
            this.writer.processRecord(this.toMap(data));
            logger.debug("error = " + data);
        } else {
            logger.warn("writer不存在");
        }
    }

    @Override
    public void close() {
        if(this.writer != null){
            this.writer.close();
        }
        if(this.outputStream != null){
            try {
                this.outputStream.close();
            } catch (IOException e) {}
        }
    }
}
