package com.walker.di.univocity;

import com.univocity.parsers.common.processor.ObjectRowWriterProcessor;
import com.univocity.parsers.tsv.TsvWriter;
import com.univocity.parsers.tsv.TsvWriterSettings;
import com.walker.di.AbstractErrorWriter;
import com.walker.di.Constants;
import com.walker.infrastructure.utils.KeyValue;

import java.io.OutputStream;
import java.util.List;

/**
 * TSV方式以Tab为分隔符，在Excel中打开能显示独立的列，而CSV都在一列中显示。
 * @author 时克英
 * @date 2023-02-02
 */
public class TsvErrorWriter extends AbstractErrorWriter {

    private TsvWriter writer = null;

    public TsvErrorWriter(OutputStream outputStream, List<String> fieldNames){
        // 加入最后一列: 错误原因
        String[] columns = this.cloneColumns(fieldNames);
        final TsvWriterSettings csvWriterSettings = new TsvWriterSettings();
        csvWriterSettings.setHeaderWritingEnabled(Boolean.TRUE);
        csvWriterSettings.setRowWriterProcessor(new ObjectRowWriterProcessor());
        csvWriterSettings.setHeaders(columns);
        writer = new TsvWriter(outputStream, csvWriterSettings);
    }

    @Override
//    public void write(Map<String, String> data, String error) {
    public void write(List<KeyValue<String, String>> data, String error) {
        if(writer != null){
//            data.put(Constants.ERROR_COLUMN_NAME, error);
            data.add(new KeyValue<>(Constants.ERROR_COLUMN_NAME, error));
            this.writer.processRecord(this.toMap(data));
//            this.writer.processRecord(data);
            logger.debug("error = " + data);
        } else {
            logger.warn("writer不存在");
        }
    }

    @Override
    public void close() {
        if(this.writer != null){
            this.writer.close();
        }
    }
}
