package com.walker.di.univocity.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BatchLoadUtils {

    /**
     * 把CSV加载到的批量列数据，转换成行数据集合，原始格式如下:
     * <pre>
     *     Map中: key = 列名称, value = 该列包含所有行的值;
     *     user_name --> ['shikeying', 'mike', 'zhangsan', null]
     * </pre>
     * @param columnsByName
     * @param fieldNames
     * @param dataSize
     * @return List中是行，数组包含一行的所有列值。
     * @date 2023-02-01
     */
    public static final List<Object[]> translateTo(Map<String, List<String>> columnsByName
            , String[] fieldNames, int dataSize){
        List<Object[]> resultList = new ArrayList<>(256);
        int columnSize = fieldNames.length;
        for(int i=0; i<dataSize; i++){
            String columnValue = null;
            Object[] data = new Object[columnSize];
            for(int j=0; j< columnSize; j++){
                columnValue = columnsByName.get(fieldNames[j]).get(i);
                data[j] = columnValue;
            }
            resultList.add(data);
        }
        return resultList;
    }
//    public static final List<Object[]> translateTo(Map<String, List<String>> columnsByName
//            , List<String> fieldNames, int dataSize){
//        List<Object[]> resultList = new ArrayList<>(256);
//        int columnSize = fieldNames.size();
//        for(int i=0; i<dataSize; i++){
//            String columnValue = null;
//            Object[] data = new Object[columnSize];
//            for(int j=0; j< fieldNames.size(); j++){
//                columnValue = columnsByName.get(fieldNames.get(j)).get(i);
//                data[j] = columnValue;
//            }
//            resultList.add(data);
//        }
//        return resultList;
//    }
}
