/*
 * Decompiled with CFR 0.152.
 */
package com.walker.di.excel;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.walker.di.excel.LoadListener;
import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.security.SystemLogMan;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataListener
extends AnalysisEventListener<Map<Integer, String>> {
    protected final transient Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected List<Object[]> rows = null;
    protected List<String> headers = null;
    private int headerSize = 0;
    private int currentHeadRowNumber = 1;
    protected LoadListener loadListener = null;
    private int headRowNumber = 2;

    public DefaultDataListener(LoadListener loadListener) {
        this.loadListener = loadListener;
        SystemLogMan.getInstance().checkMan();
    }

    public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
        if (this.currentHeadRowNumber < this.headRowNumber) {
            this.logger.debug("\u8868\u5934\u884c\u5927\u4e8e1\uff0c\u5ffd\u7565\u6539\u884c\uff0c\u4ec5\u5904\u7406\u6700\u540e\u4e00\u884c\u8868\u5934");
            ++this.currentHeadRowNumber;
            return;
        }
        if (this.headers == null) {
            this.headers = new ArrayList<String>();
            for (String head : headMap.values()) {
                this.headers.add(head);
            }
            this.headerSize = this.headers.size();
        }
    }

    public void invoke(Map<Integer, String> integerStringMap, AnalysisContext analysisContext) {
        this.increaseOneData(integerStringMap);
    }

    void increaseOneData(Map<Integer, String> integerStringMap) {
        if (this.headers == null) {
            throw new ApplicationRuntimeException("\u8868\u5934\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u7ee7\u7eed\u5bfc\u5165\u6570\u636e", null);
        }
        if (this.rows == null) {
            this.rows = new ArrayList<Object[]>(256);
        }
        Object[] one = new Object[this.headerSize];
        String value = null;
        for (int i = 0; i < this.headerSize; ++i) {
            value = integerStringMap.get(i);
            one[i] = StringUtils.isEmpty((String)value) ? "" : value;
        }
        this.rows.add(one);
    }

    public void doAfterAllAnalysed(AnalysisContext analysisContext) {
        this.logger.info(".........\u5bfc\u5165\u5e76\u4fdd\u5b58\u5b8c\u6210!");
    }

    public List<Object[]> getRows() {
        return this.rows;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public void setHeadRowNumber(int headRowNumber) {
        this.headRowNumber = headRowNumber;
    }
}

