/*
 * Decompiled with CFR 0.152.
 */
package com.walker.di.univocity;

import com.univocity.parsers.common.processor.ObjectRowWriterProcessor;
import com.univocity.parsers.common.processor.RowWriterProcessor;
import com.univocity.parsers.csv.CsvWriter;
import com.univocity.parsers.csv.CsvWriterSettings;
import com.walker.di.AbstractErrorWriter;
import com.walker.infrastructure.utils.KeyValue;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class CsvErrorWriter
extends AbstractErrorWriter {
    private CsvWriter writer = null;
    private OutputStream outputStream = null;

    public CsvErrorWriter(OutputStream outputStream, List<String> fieldNames) {
        this.outputStream = outputStream;
        String[] columns = this.cloneColumns(fieldNames);
        CsvWriterSettings csvWriterSettings = new CsvWriterSettings();
        csvWriterSettings.setHeaderWritingEnabled(Boolean.TRUE.booleanValue());
        csvWriterSettings.setRowWriterProcessor((RowWriterProcessor)new ObjectRowWriterProcessor());
        csvWriterSettings.setHeaders(columns);
        this.writer = new CsvWriter(outputStream, csvWriterSettings);
    }

    public void write(List<KeyValue<String, String>> data, String error) {
        if (this.writer != null) {
            data.add((KeyValue<String, String>)new KeyValue((Object)"error", (Object)error));
            this.writer.processRecord(this.toMap(data));
            this.logger.debug("error = " + data);
        } else {
            this.logger.warn("writer\u4e0d\u5b58\u5728");
        }
    }

    public void close() {
        if (this.writer != null) {
            this.writer.close();
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

