/*
 * Decompiled with CFR 0.152.
 */
package com.walker.di.excel;

import com.alibaba.excel.context.AnalysisContext;
import com.walker.di.BusinessImportException;
import com.walker.di.excel.DefaultDataListener;
import com.walker.di.excel.LoadListener;
import com.walker.infrastructure.ApplicationRuntimeException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class BatchDataListener
extends DefaultDataListener {
    private long currentDataRowCount = 0L;
    private long saveSizeOnce = 200L;
    private long sleepMillSeconds = 0L;

    public BatchDataListener(LoadListener loadListener) {
        super(loadListener);
        if (loadListener == null) {
            throw new IllegalArgumentException("LoadListener is required!");
        }
    }

    @Override
    public void invoke(Map<Integer, String> integerStringMap, AnalysisContext analysisContext) {
        this.increaseOneData(integerStringMap);
        ++this.currentDataRowCount;
        if (this.currentDataRowCount >= this.saveSizeOnce) {
            this.doSaveOnce();
            this.currentDataRowCount = 0L;
            if (this.sleepMillSeconds > 0L) {
                try {
                    TimeUnit.MILLISECONDS.sleep(this.sleepMillSeconds);
                    this.logger.debug("-----> sleep: " + this.sleepMillSeconds);
                }
                catch (InterruptedException e) {
                    this.logger.error("\u95f4\u9694\u7b49\u5f85(\u9632\u6b62CUP\u8fc7\u9ad8)\uff0c\u51fa\u73b0\u5f02\u5e38:" + e.getMessage());
                }
            }
        }
    }

    @Override
    public void doAfterAllAnalysed(AnalysisContext analysisContext) {
        this.logger.info(".........Excel\u64cd\u4f5c\u5b8c\u6210!");
        if (this.rows != null) {
            this.logger.warn("excel\u5df2\u52a0\u8f7d\u5b8c\u6bd5\uff0c\u53d1\u73b0\u5b58\u5728\u672a\u4fdd\u5b58\u6570\u636e\uff0c\u7acb\u5373\u4fdd\u5b58:" + this.rows.size());
            this.doSaveOnce();
        }
        if (this.headers != null) {
            this.headers.clear();
        }
    }

    private void doSaveOnce() {
        try {
            this.loadListener.onSave(this.rows, this.headers);
            this.rows.clear();
            this.rows = null;
        }
        catch (BusinessImportException e) {
            if (this.loadListener.getErrorWriter() != null) {
                this.loadListener.getErrorWriter().close();
            }
            throw new ApplicationRuntimeException("loadListener\u4fdd\u5b58\u5bfc\u5165\u6570\u636e\u9519\u8bef:" + e.getMessage(), (Throwable)e);
        }
    }

    public void setSaveSizeOnce(long saveSizeOnce) {
        this.saveSizeOnce = saveSizeOnce;
    }

    public void setSleepMillSeconds(long sleepMillSeconds) {
        this.sleepMillSeconds = sleepMillSeconds;
    }
}

