/*
 * Decompiled with CFR 0.152.
 */
package com.walker.di.excel;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.walker.di.BatchLoadListener;
import com.walker.di.BusinessImportException;
import com.walker.di.DataImportException;
import com.walker.di.ErrorWriter;
import com.walker.di.excel.BatchDataListener;
import com.walker.di.excel.DefaultDataListener;
import com.walker.di.excel.ExcelErrorWriter;
import com.walker.di.excel.LoadListener;
import com.walker.di.support.InputStreamDataImportor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public abstract class ExcelDataImportor
extends InputStreamDataImportor {
    private String batchError = null;
    private LoadListener loadListener = new InternalLoadListener();

    public void setBatchEnabled() {
        this.setBatchSize(1024L);
    }

    public void setBatchSize(long batchSize) {
        super.setBatchSize(batchSize);
        this.setBatchLoadListener(new BatchLoadListener(){

            public List<Object[]> onBatchLoad(Map<String, List<String>> columnsByName, String[] fieldNames, int dataSize) {
                throw new UnsupportedOperationException("\u4e0d\u4f1a\u4f7f\u7528\u5230\u8be5\u5bf9\u8c61");
            }
        });
    }

    protected List<Object[]> acquireImportDataList(Object source) throws DataImportException {
        this.checkSource(source);
        try {
            DefaultDataListener dataListener = new DefaultDataListener(null);
            dataListener.setHeadRowNumber(this.getHeadRowNumber());
            ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)((InputStream)source), (ReadListener)dataListener).sheet(Integer.valueOf(0)).headRowNumber(Integer.valueOf(this.getHeadRowNumber()))).doRead();
            this.setFieldNames(dataListener.getHeaders());
            List<Object[]> list = dataListener.getRows();
            return list;
        }
        catch (Exception ex) {
            throw new DataImportException("EasyExcel\u89e3\u6790\u5f02\u5e38:" + ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.releaseSource(source);
        }
    }

    protected void acquireImportBatch(BatchLoadListener batchLoadListener, Object source) throws DataImportException {
        BatchDataListener dataListener = new BatchDataListener(this.loadListener);
        dataListener.setHeadRowNumber(this.getHeadRowNumber());
        dataListener.setSaveSizeOnce(this.getSaveSizeOnce());
        dataListener.setSleepMillSeconds(this.getSleepMillSeconds());
        try {
            ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)((InputStream)source), (ReadListener)dataListener).sheet(Integer.valueOf(0)).headRowNumber(Integer.valueOf(this.getHeadRowNumber()))).doRead();
        }
        catch (Exception ex) {
            throw new DataImportException("EasyExcel\u6279\u91cf\u89e3\u6790\u5f02\u5e38:" + ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.releaseSource(source);
        }
    }

    protected ErrorWriter acquireErrorWriter(String id, List<String> fieldNames) {
        File errorFile = null;
        BufferedOutputStream errorFileStream = null;
        errorFile = new File(this.getErrorFile());
        try {
            errorFileStream = new BufferedOutputStream(new FileOutputStream(errorFile));
            ExcelErrorWriter errorWriter = new ExcelErrorWriter(errorFileStream, fieldNames);
            if (this.loadListener != null) {
                this.loadListener.setErrorWriter((ErrorWriter)errorWriter);
            }
            return errorWriter;
        }
        catch (FileNotFoundException e) {
            this.logger.error("\u672a\u627e\u5230'\u9519\u8bef\u6587\u4ef6':" + errorFile.getAbsolutePath(), (Throwable)e);
            return null;
        }
    }

    public String getBatchError() {
        return this.batchError;
    }

    public String getImportFileSuffix() {
        return "error.xlsx";
    }

    private class InternalLoadListener
    implements LoadListener {
        private ErrorWriter errorWriter = null;

        private InternalLoadListener() {
        }

        @Override
        public void onSave(List<Object[]> rows, List<String> fieldNames) throws BusinessImportException {
            try {
                ExcelDataImportor.this.setFieldNames(fieldNames);
                ExcelDataImportor.this.doExecuteImport(rows, ExcelDataImportor.this.getFieldNames());
            }
            catch (DataImportException e) {
                ExcelDataImportor.this.batchError = e.getMessage();
                if (e instanceof BusinessImportException) {
                    BusinessImportException bex = (BusinessImportException)((Object)e);
                    throw bex;
                }
                throw new BusinessImportException("\u6279\u91cf\u5bfc\u5165\u76d1\u542c\u9519\u8bef:" + e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public void setErrorWriter(ErrorWriter errorWriter) {
            this.errorWriter = errorWriter;
        }

        @Override
        public ErrorWriter getErrorWriter() {
            return this.errorWriter;
        }
    }
}

