/*
 * Decompiled with CFR 0.152.
 */
package com.walker.di.excel;

import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.walker.di.AbstractErrorWriter;
import com.walker.infrastructure.utils.KeyValue;
import com.walker.infrastructure.utils.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class ExcelErrorWriter
extends AbstractErrorWriter {
    private ExcelWriter excelWriter = null;
    private WriteSheet writeSheet = null;
    private OutputStream outputStream = null;

    public ExcelErrorWriter(OutputStream outputStream, List<String> fieldNames) {
        this.outputStream = outputStream;
        ExcelWriterBuilder writer = EasyExcelFactory.write((OutputStream)outputStream);
        writer.head(this.getHeaders(fieldNames));
        this.excelWriter = writer.build();
        this.writeSheet = new WriteSheet();
        this.writeSheet.setSheetName("sheet1");
    }

    public void write(List<KeyValue<String, String>> data, String error) {
        if (this.excelWriter != null) {
            data.add((KeyValue<String, String>)new KeyValue((Object)"error", (Object)error));
            ArrayList errorList = new ArrayList(2);
            ArrayList<String> one = new ArrayList<String>(data.size() + 2);
            for (KeyValue<String, String> kv : data) {
                one.add((String)kv.getValue());
            }
            errorList.add(one);
            this.excelWriter.write(errorList, this.writeSheet);
            this.logger.debug("error = " + data);
        }
    }

    public void close() {
        if (this.excelWriter != null) {
            this.excelWriter.finish();
            this.excelWriter.close();
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private List<List<String>> getHeaders(List<String> fieldNames) {
        ArrayList<List<String>> headers = new ArrayList<List<String>>();
        for (String headerId : fieldNames) {
            headers.add(StringUtils.asList((String[])new String[]{"\u8bf4\u660e\u5b57\u6bb5", headerId}));
        }
        headers.add(StringUtils.asList((String[])new String[]{"\u9519\u8bef\u539f\u56e0", "error"}));
        return headers;
    }
}

