/*
 * Decompiled with CFR 0.152.
 */
package com.walker.di.excel;

import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.walker.di.AbstractTemplateGenerator;
import com.walker.di.TemplateException;
import com.walker.infrastructure.utils.FileCopyUtils;
import com.walker.infrastructure.utils.StringUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class ExcelTemplateGenerator
extends AbstractTemplateGenerator<File> {
    protected File writeContent(List<Map<String, String>> data, Object option) throws TemplateException {
        this.logger.debug(data.toString());
        this.logger.debug(option.toString());
        String templatePath = this.acquireWriteFilePath(option);
        if (StringUtils.isEmpty((String)templatePath)) {
            throw new TemplateException("\u65e0\u6cd5\u83b7\u53d6\u6a21\u677f\u5199\u5165\u8def\u5f84: acquireWriteFilePath() = null!", null);
        }
        File templateFile = new File(templatePath);
        this.logger.info("\u751f\u6210\u7684\u6a21\u677f\u6587\u4ef6\uff1a" + templateFile.getAbsolutePath());
        InputStream templateFileStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("import_error_template.xlsx");
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(templateFile));
            FileCopyUtils.copy((InputStream)templateFileStream, (OutputStream)outputStream);
            outputStream = new BufferedOutputStream(new FileOutputStream(templateFile));
            ExcelWriterBuilder writer = EasyExcelFactory.write((OutputStream)outputStream);
            WriteSheet writeSheet = new WriteSheet();
            writeSheet.setSheetName("sheet1");
            List<List<String>> header = this.getHeader(data);
            writer.head(header);
            ExcelWriter excelWriter = writer.build();
            excelWriter.write(this.getEmptyRow(data), writeSheet);
            excelWriter.finish();
            excelWriter.close();
            File file = templateFile;
            return file;
        }
        catch (Exception ex) {
            throw new TemplateException("\u5199\u5165\u6a21\u677f\u5185\u5bb9\u9519\u8bef:" + ex.getMessage() + ", templatePath=" + templatePath, (Throwable)ex);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                    this.logger.debug("outputStream \u5df2\u5173\u95ed");
                }
                catch (IOException iOException) {}
            }
        }
    }

    private List<List<String>> getEmptyRow(List<Map<String, String>> headers) {
        ArrayList<List<String>> content = new ArrayList<List<String>>();
        ArrayList<String> testRow = new ArrayList<String>();
        for (int i = 0; i < headers.size(); ++i) {
            testRow.add("");
        }
        content.add(testRow);
        return content;
    }

    private List<List<String>> getHeader(List<Map<String, String>> headers) {
        ArrayList<List<String>> headerList = new ArrayList<List<String>>();
        for (Map<String, String> oneFieldInfo : headers) {
            for (Map.Entry<String, String> entry : oneFieldInfo.entrySet()) {
                headerList.add(StringUtils.asList((String[])new String[]{entry.getValue(), entry.getKey()}));
            }
        }
        return headerList;
    }

    protected abstract String acquireWriteFilePath(Object var1);
}

