/*
 * Decompiled with CFR 0.152.
 */
package com.walker.di.univocity;

import com.univocity.parsers.common.processor.BatchedColumnProcessor;
import com.univocity.parsers.common.processor.ObjectRowListProcessor;
import com.univocity.parsers.common.processor.core.Processor;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import com.walker.di.BatchLoadListener;
import com.walker.di.DataImportException;
import com.walker.di.ErrorWriter;
import com.walker.di.support.InputStreamDataImportor;
import com.walker.di.univocity.CsvErrorWriter;
import com.walker.di.univocity.util.BatchLoadUtils;
import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.infrastructure.utils.StringUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public abstract class CsvDataImportor
extends InputStreamDataImportor {
    private String batchError = null;

    public String getBatchError() {
        return this.batchError;
    }

    public void setBatchEnabled() {
        this.setBatchSize(1024L);
    }

    public void setBatchSize(long batchSize) {
        super.setBatchSize(batchSize);
        this.setBatchLoadListener(new InternalBatchListenerImpl());
    }

    public String getImportFileSuffix() {
        return "error.csv";
    }

    protected List<Object[]> acquireImportDataList(Object source) throws DataImportException {
        this.checkSource(source);
        try {
            ObjectRowListProcessor rowListProcessor = new ObjectRowListProcessor();
            CsvParserSettings csvParserSettings = new CsvParserSettings();
            csvParserSettings.setHeaderExtractionEnabled(true);
            csvParserSettings.setMaxColumns(64);
            if (this.getIgnoreRows() > 0) {
                csvParserSettings.setNumberOfRowsToSkip((long)this.getIgnoreRows());
            }
            csvParserSettings.setProcessor((Processor)rowListProcessor);
            CsvParser csvParser = new CsvParser(csvParserSettings);
            csvParser.parse((InputStream)source);
            String[] headers = rowListProcessor.getHeaders();
            if (headers == null || headers.length == 0) {
                throw new DataImportException("\u5bfc\u5165\u6587\u4ef6\u672a\u627e\u5230\u5217\u540d\u79f0\u884c", null);
            }
            this.setFieldNames(Arrays.asList(headers));
            List list = rowListProcessor.getRows();
            return list;
        }
        catch (Exception ex) {
            throw new DataImportException("CsvParser\u89e3\u6790\u5f02\u5e38:" + ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.releaseSource(source);
        }
    }

    protected void acquireImportBatch(final BatchLoadListener batchLoadListener, final Object source) throws DataImportException {
        this.checkSource(source);
        final long sleepMillSeconds = this.getSleepMillSeconds();
        CsvParserSettings csvParserSettings = new CsvParserSettings();
        csvParserSettings.setMaxColumns(64);
        if (this.getIgnoreRows() > 0) {
            csvParserSettings.setNumberOfRowsToSkip((long)this.getIgnoreRows());
        }
        csvParserSettings.setHeaderExtractionEnabled(true);
        BatchedColumnProcessor batchedColumnProcessor = new BatchedColumnProcessor((int)this.getBatchSize()){

            public void batchProcessed(int dataSize) {
                CsvDataImportor.this.setFieldNames(Arrays.asList(this.getHeaders()));
                Map columnsByName = this.getColumnValuesAsMapOfNames();
                List rows = batchLoadListener.onBatchLoad(columnsByName, this.getHeaders(), dataSize);
                if (StringUtils.isEmptyList((List)rows)) {
                    CsvDataImportor.this.logger.error("\u672a\u6279\u91cf\u89e3\u6790\u5230\u4efb\u4f55\u6570\u636e:batchLoadListener.onBatchLoad, dataSize=" + dataSize);
                    return;
                }
                CsvDataImportor.this.logger.debug("\u6279\u91cf\u89e3\u6790\u5230\u6570\u636e\u91cf:" + rows.size());
                try {
                    CsvDataImportor.this.doExecuteImport(rows, CsvDataImportor.this.getFieldNames());
                }
                catch (DataImportException e) {
                    CsvDataImportor.this.batchError = e.getMessage();
                    throw new ApplicationRuntimeException("\u6279\u91cf\u5bfc\u5165\u76d1\u542c\u9519\u8bef:" + e.getMessage(), (Throwable)e);
                }
                finally {
                    CsvDataImportor.this.releaseSource(source);
                }
                if (sleepMillSeconds > 0L) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(sleepMillSeconds);
                        CsvDataImportor.this.logger.debug("-----> sleep: " + sleepMillSeconds);
                    }
                    catch (InterruptedException e) {
                        CsvDataImportor.this.logger.error("\u95f4\u9694\u7b49\u5f85(\u9632\u6b62CUP\u8fc7\u9ad8)\uff0c\u51fa\u73b0\u5f02\u5e38:" + e.getMessage());
                    }
                }
            }
        };
        csvParserSettings.setProcessor((Processor)batchedColumnProcessor);
        CsvParser csvParser = new CsvParser(csvParserSettings);
        try {
            csvParser.parse((InputStream)source);
        }
        catch (Exception ex) {
            throw new DataImportException(ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.releaseSource(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ErrorWriter acquireErrorWriter(String id, List<String> fieldNames) {
        InputStream templateFileStream = null;
        BufferedOutputStream errorFileStream = null;
        File errorFile = null;
        try {
            errorFile = new File(this.getErrorFile());
            errorFileStream = new BufferedOutputStream(new FileOutputStream(errorFile));
            CsvErrorWriter csvErrorWriter = new CsvErrorWriter(errorFileStream, fieldNames);
            return csvErrorWriter;
        }
        catch (FileNotFoundException e) {
            this.logger.error("\u672a\u627e\u5230'\u9519\u8bef\u6a21\u677f\u6587\u4ef6':import_error_template.xlsx", (Throwable)e);
            ErrorWriter errorWriter = null;
            return errorWriter;
        }
        finally {
            if (templateFileStream != null) {
                try {
                    templateFileStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private class InternalBatchListenerImpl
    implements BatchLoadListener {
        private InternalBatchListenerImpl() {
        }

        public List<Object[]> onBatchLoad(Map<String, List<String>> columnsByName, String[] fieldNames, int dataSize) {
            return BatchLoadUtils.translateTo(columnsByName, fieldNames, dataSize);
        }
    }
}

