package com.walker.file;

import java.io.File;
import java.util.List;

@Deprecated
public interface FileEngine {

	/**
	 * 文件存储方式：文件系统、数据库、内存等
	 * @author shikeying
	 *
	 */
	@Deprecated
	public enum StoreType {
		FileSystem{
			public int getIndex(){
				return INDEX_FS;
			}
		},
		Database{
			public int getIndex(){
				return INDEX_DB;
			}
		},
		Memory{
			public int getIndex(){
				return INDEX_MM;
			}
		};
		
		static final int INDEX_FS = 0;
		static final int INDEX_DB = 1;
		static final int INDEX_MM = 2;
		
		public int getIndex(){
			throw new AbstractMethodError();
		}
		
		public static final StoreType getStoreType(int index){
			if(index == INDEX_FS){
				return FileSystem;
			} else if(index == INDEX_DB){
				return Database;
			} else {
				throw new UnsupportedOperationException();
			}
		}
	}
	
	/**
	 * 返回存储文件的根路径，如：d:/file_store/
	 * @return
	 */
	String getFileStoreRootPath();
	
	/**
	 * 读入上传的文件信息
	 * @param request 请求对象
	 * @param fileFormId 文件在界面上的ID
	 * @param st 存储方式：数据库、文件等。
	 * @return 返回生成的文件定义对象
	 */
	List<FileMeta> readFiles(Object request, String fileFormId, StoreType st) throws FileOperateException;
	
	/**
	 * 把得到的文件信息写入到持久化存储设备中，如：数据库或磁盘中。</p>
	 * 此方法通常被应用系统在事务控制层中调用，以保持与数据库事务的一致性。
	 * @param fileMetas 获取的文件集合
//	 * @param thumb 是否缩略图
	 * @return
	 * @throws FileOperateException
	 */
	List<String> writeFiles(List<FileMeta> fileMetas) throws FileOperateException;
	
//	/**
//	 * 方法同上，仅仅返回参数不同。
//	 * @param fileMetas
//	 * @return
//	 * @throws FileOperateException
//	 */
//	List<FileMeta> writeFilesForMeta(List<FileMeta> fileMetas) throws FileOperateException;
	
	/**
	 * 创建一个空的文件，此文件会存储到文件系统中，系统也会记录其信息。
	 * @param filename 文件全名，如：abc.xls
	 * @return 返回文件元数据对象
	 */
	FileMeta createEmptyFile(String filename, String mimeType);
	
	/**
	 * 根据文件ID集合，获取文件对象列表
	 * @param ids 这些ID是系统在创建时自动生成的。
	 * @return
	 * @throws FileOperateException
	 */
	List<FileMeta> listFiles(List<String> ids) throws FileOperateException;
	
	/**
	 * 根据ID获得一个文件对象
	 * @param id
	 * @return
	 */
	FileMeta getFile(String id);
	
	/**
	 * 返回JAVA文件对象，此方法只有在'存储方式'为'文件系统时'才有效
	 * @param filePath 相对文件路径，在数据库中存储的path字段
	 * @return
	 */
	File getFileObject(String filePath);
	
	/**
	 * 从系统删除一个文件
	 * @param id
	 * @throws FileOperateException
	 */
	void removeFile(String id) throws FileOperateException;
	
	/**
	 * 设置使用文件系统存储文件时，根目录，如：d:/files/ or home/
	 * @param rootPath
	 */
	void setFileStoreRootPath(String rootPath);
	
	void setFileReader(FileReader reader);
}
